% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CombineCollinearRowsCols.R
\name{CombineCollinearRowsCols}
\alias{CombineCollinearRowsCols}
\title{Removes rows and columns of zeros and optionnally, row or column duplicates}
\usage{
CombineCollinearRowsCols(Y, rows = F, cols = F)
}
\arguments{
\item{Y}{A matrix or an object that can be coerced to a matrix}

\item{rows}{Logical: Will duplicate rows be removed?}

\item{cols}{Logical: Will duplicate columns be removed?}
}
\value{
A matrix with rows and columns removed as requested
}
\description{
Removes rows and columns of zeros and optionnally, row or column duplicates
}
\details{
Rows and columns of zeros will be removed.

A matrix of zeros will be returned as matrix with 0 row and 0 column.

If rows 1,2,3 are combined, the name of row 1 is kept. Similarly for columns.
}
\examples{
CombineCollinearRowsCols(matrix(1:3,nrow=3,ncol=2),cols=TRUE)

CombineCollinearRowsCols(cbind(matrix(1:3,nrow=3,ncol=2),rep(0,3)),cols=TRUE)

CombineCollinearRowsCols(cbind(matrix(1:3,nrow=3,ncol=2),rep(0,3)))

CombineCollinearRowsCols(matrix(0,nrow=3,ncol=3))

CombineCollinearRowsCols(rodent,TRUE,FALSE)

}
