% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_error.R
\name{report_error}
\alias{report_error}
\alias{report2console}
\alias{report2twitter}
\alias{report2gmail}
\title{Report errors to console and twitter}
\usage{
report2console(line_no = NULL, context = NULL, error_message = NULL,
  advice = NULL, build_status = NULL, authors = NULL,
  report_name = NULL, extra_cat_ante = NULL, extra_cat_post = NULL)

report2twitter(preamble = NULL, report_name, build_status, error_message,
  line_no = NULL, context = NULL, authors, extra_cat_ante = NULL,
  extra_cat_post = NULL, globalEnv = NULL)

report2gmail(preamble = NULL, report_name, build_status, error_message,
  line_no = NULL, context = NULL, authors, extra_cat_ante = NULL,
  extra_cat_post = NULL)
}
\arguments{
\item{line_no}{The line number locating the source of the error.}

\item{context}{THe content of the file to provide context to the error.}

\item{error_message}{The error message to display beyond the console.}

\item{advice}{Advice to the user: how should the detected error be resolved in general?}

\item{build_status}{What should the build status be reported as?}

\item{authors}{Text to alert the authors (such as a twitter handle).}

\item{report_name}{Name of project whose errors are being reported.}

\item{extra_cat_ante}{Character vector extra messages (placed before \code{context}).}

\item{extra_cat_post}{Character vector extra messages (placed after \code{context}).}

\item{preamble}{Message to appear before other messages.}

\item{globalEnv}{The environment in which tweet statuses should be assigned. 
The default, \code{NULL}, is an error. The environment must be set by the user
to comply with (reasonable) CRAN requirements to not interfere with the user's 
environment.}
}
\description{
Report errors to console and twitter
}
