% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{dNTS}
\alias{dNTS}
\title{Density function of the normal tempered stable (NTS) distribution}
\usage{
dNTS(
  x,
  alpha = NULL,
  beta = NULL,
  delta = NULL,
  lambda = NULL,
  mu = NULL,
  theta = NULL,
  dens_method = "FFT",
  a = -20,
  b = 20,
  nf = 2048
)
}
\arguments{
\item{x}{A numeric vector of quantile.}

\item{alpha}{A real number between 0 and 1.}

\item{beta}{Any real number.}

\item{delta}{A real number > 0.}

\item{lambda}{A  real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{A vector of all other arguments.}

\item{dens_method}{Currently, useless param, as it does nothing and FFT is
always used.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -20
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 20
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size.}
}
\value{
As \code{x} is a numeric vector, the return value is also a numeric
vector of densities.
}
\description{
The probability density function (PDF) of the normal tempered stable
distributions is not available in closed form.
Relies on fast Fourier transform (FFT) applied to the characteristic
function.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, beta, delta, lambda,
mu)}. Either provide the parameters individually OR provide \code{theta}.
Currently, the only method is FFT.
}
\examples{
x <- seq(0,15,0.25)
y <- dNTS(x,0.8,1,1,1,1)
plot(x,y)

}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'
}
