% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{FitExp}
\alias{FitExp}
\title{Exponential Distribution Parameter Estimation}
\usage{
FitExp(
  data,
  sig = 0.05,
  status_name = "status",
  tau = NULL,
  time_name = "time"
)
}
\arguments{
\item{data}{Data.frame.}

\item{sig}{Significance level, for CIs.}

\item{status_name}{Name of the status indicator, 1 if observed, 0 if censored.}

\item{tau}{Optional truncation times for calculating RMSTs.}

\item{time_name}{Name of column containing the time to event.}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated model parameters.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance of the time to event distribution.}
 \item{RMST}{The estimated RMSTs, if tau was specified.}
}
}
\description{
Estimates parameters for exponential event times subject to non-informative
right censoring. The exponential distribution is parameterized in terms
of the rate \eqn{\lambda}: \deqn{f(t) = \lambda e^{-\lambda t}, t>0}
}
\examples{
# Generate exponential event time data with 20\% censoring.
data <- GenData(n = 1e3, dist = "exp", theta = c(2), p = 0.2)

# Estimate parameters.
fit <- FitParaSurv(data, dist = "exp")
}
