% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{FitWeibull}
\alias{FitWeibull}
\title{Weibull Distribution Parameter Estimation}
\usage{
FitWeibull(
  data,
  init = list(),
  sig = 0.05,
  status_name = "status",
  tau = NULL,
  time_name = "time"
)
}
\arguments{
\item{data}{Data.frame.}

\item{init}{List containing the initial value for the shape, \eqn{\alpha}.}

\item{sig}{Significance level, for CIs.}

\item{status_name}{Name of the status indicator, 1 if observed, 0 if censored.}

\item{tau}{Optional truncation times for calculating RMSTs.}

\item{time_name}{Name of column containing the time to event.}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated shape \eqn{\alpha} and rate \eqn{\lambda}.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
 \item{RMST}{The estimated RMSTs, if tau was specified.}
}
}
\description{
Estimates parameters for Weibull event times subject to non-informative
right censoring. The Weibull distribution is parameterized in terms
of the shape \eqn{\alpha} and rate \eqn{\lambda}:
\deqn{f(t) = \alpha\lambda^{\alpha}t^{\alpha-1}e^{-(\lambda t)^{\alpha}}, t>0}
}
\examples{
# Generate Weibull data with 20\% censoring.
data <- GenData(n = 1e3, dist = "weibull", theta = c(2, 2), p = 0.2)

# Estimate parameters.
fit <- FitParaSurv(data, dist = "weibull")
}
