% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreambleAdjustment.R
\name{ReplacePreambleCommand}
\alias{ReplacePreambleCommand}
\title{ReplacePreambleCommand}
\usage{
ReplacePreambleCommand(x, commandName, commandValue)
}
\arguments{
\item{x}{A character vector, each element is suppose to represent a line}

\item{commandName}{A string identifying either the command name}

\item{commandValue}{Replacement for the definition of commandName}
}
\value{
A character vector, with the preamble, replacing all instances of
\code{ \\newcommand\\commandName\{<random text>\}} with
\code{ \\newcommand\\commandName\{commandValue\}}
}
\description{
This functions gets a character vector in which each element represents a line of
a preamble of a 'LaTeX' document, and it replaces the definition of the command \code{\\commandName} to have the value \code{commandValue}.
}
\details{
It only modifies the value of the command by replacing instances of

\code{\\newcommand\{\\commandName\}\{<previous definition>\}} with instances of

\code{\\newcommand\{\\commandName\}\{<commandValue>\}}.

Keep in mind that both \code{commandName} and \code{commandValue} are placed directly inside a regex.

If you want to "hide" a certain definition of a command from being found and replaced by this function,  simply define it by using \code{\\def} or \code{\\newcommand*} or a \code{\\renewcommand} when you define them.


Make sure you are using a one-line definition in commands that you want replaced, since this won't be able to detect commands that are defined in multiple lines in 'LaTeX'.

Also, note how certain invalid things in 'LaTeX' would still be matched by this regex,
however you should find those errors before you start using this program since those errors would not allow you to compile the 'LaTeX' document on the first place.

Lastly, if it doesn't find a command on the document, it silently ignores it.
}
\examples{
new_preamble <- ReplacePreambleCommand( TexExamRandomizer::testdoc$preamble, "nickname", "Alex")
}
\seealso{
Other Preamble adjustment: \code{\link{ReplaceFromTable}}
}
