% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Grading.R
\name{ObtainExamStats}
\alias{ObtainExamStats}
\title{Obtaining exam statistics}
\usage{
ObtainExamStats(OriginalExamAnswerSheet, ExamAnswerParsedList,
  names.FullExamOriginalCols)
}
\arguments{
\item{OriginalExamAnswerSheet}{The answer sheet of the original exam. (In this package the convention is the exam version "0")}

\item{ExamAnswerParsedList}{A parsed list for every student, as outputted by \code{\link{GradeExams}}}

\item{names.FullExamOriginalCols}{Names of those columns that in the answer sheet identify for all versions where that item is found on the original columns, (i.e., as ordered from the original version exam)}
}
\value{
Returns the \code{OriginalExamAnswerSheet} with a column added to it, named "\code{ExamAnswerCount}" that counts the number of answers for each question
}
\description{
This function gets an answer sheet of the original version of the exam as a data frame, and a parsed list, which is obtained from \code{\link{GradeExams}} and it outputs the statistics of how many answers are parsed exam, that is graded and obtains from there
}
\examples{

asheet_file <-
    system.file(
        "extdata",
        "ExampleTables",
        "ExampleAnswerSheet.csv",
        package = "TexExamRandomizer")
responses_file <-
    system.file(
        "extdata",
        "ExampleTables",
        "ExampleResponses.csv",
        package = "TexExamRandomizer")
FullAnswerSheet <-
    read.csv(
        asheet_file,
        header = TRUE,
        stringsAsFactors = FALSE,
        na.strings = c("", "NA", "Na"),
        strip.white = TRUE)
Responses <- read.csv(
    responses_file,
    header = TRUE,
    stringsAsFactors = FALSE,
    na.strings = c("", "NA", "Na"),
    strip.white = TRUE)
compiledanswers <-
    WhichAnswerOriginal(
        StudentAnswers = Responses,
        FullExamAnswerSheet = FullAnswerSheet,
        names.StudentAnswerQCols = grep(
            names(Responses),
            pattern = "^Q.*[[:digit:]]",
            value = TRUE),
        names.StudentAnswerExamVersion = grep(
            names(Responses),
            pattern = "Version",
            value = TRUE),
        OriginalExamVersion = 0,
        names.FullExamVersion = "Version",
        names.FullExamOriginalCols = grep(
            names(FullAnswerSheet),
            pattern = "_original",
            value = TRUE),
        names.CorrectAndIncorrectCols = c(
            "choice",
            "CorrectChoice")
    )
OriginalAnswerSheet <- FullAnswerSheet[FullAnswerSheet$Version == 0,]
ExamStats <-
    ObtainExamStats(
        OriginalExamAnswerSheet = OriginalAnswerSheet,
        ExamAnswerParsedList = compiledanswers,
        names.FullExamOriginalCols =  grep(
            names(FullAnswerSheet),
            pattern = "_original",
            value = TRUE)
    )
}
\seealso{
Other Grading Exams: \code{\link{GradeExams}}
}
