% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voltageCurve.R
\name{voltageCurve}
\alias{voltageCurve}
\title{Calculate V-DeltaT Curve for Given Indices}
\usage{
voltageCurve(Tdata, x, StdRes, StdTherm_Val, StdTherm_Beta)
}
\arguments{
\item{Tdata}{a vector of temperature-change values}

\item{x}{a vector of the indices of each component}

\item{StdRes}{a vector of available resistor values}

\item{StdTherm_Val}{a vector of available nominal thermistor resistances}

\item{StdTherm_Beta}{a vector of of thermistor temperature coefficients}
}
\value{
the voltage values at Point B
}
\description{
Calculating the temperature-change-voltage curve for a
   particular set of indices for each component corresponding to the
   values from a standard components space.
}
\examples{
data(CompValues)
Tdata <- seq(-40, 85, by=5)
R_id <- c(2, 1, 4, 2, 1, 3)
Res <- CompValues$Res
ThVal <- CompValues$ThVal
ThBeta <- CompValues$ThBeta
voltageCurve(Tdata, R_id, Res, ThVal, ThBeta)
}
