% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difftime.R
\name{asDifftime}
\alias{asDifftime}
\title{Create Time Differences, Extended}
\usage{
asDifftime(
  tim,
  units = names(timeUnits()),
  negative_do = stop(sQuote(deparse1(substitute(tim))), " has negative value!"),
  ...
)
}
\arguments{
\item{tim}{\link[base]{numeric} or \link[base]{difftime} object,
similar usage as in function \link[base]{as.difftime}}

\item{units}{\link[base]{character} scalar,
similar usage as in function \link[base]{as.difftime},
but with additional options \code{'months'} and \code{'years'}}

\item{negative_do}{exception handling
if input \code{tim} has negative element(s).
Default is to \link[base]{stop}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \link{asDifftime} returns a \link[base]{difftime} object.
}
\description{
To create \link[base]{difftime} object
with additional time units \code{'months'} and \code{'years'}.
}
\details{
Function \link{asDifftime} improves function \link[base]{as.difftime} in terms that
\itemize{
\item {If input \code{tim} is a \link[base]{difftime} object,
function \link{units_difftime<-} is called and the unit of \code{tim} is updated.
In function \link[base]{as.difftime}, \code{tim} is returned directly, i.e., parameter \code{units} is ignored}
\item {Time units \code{'months'} and \code{'years'} are supported,
in addition to \code{'secs'}, \code{'mins'}, \code{'hours'}, \code{'days'}, \code{'weeks'} supported in function \link[base]{as.difftime}.
Moreover, partial matching (via function \link[base]{match.arg}) is allowed,
while function \link[base]{as.difftime} requires exact matching.}
\item {End user may choose to \link[base]{stop} if \code{tim} has negative values.
Function \link[base]{as.difftime} does not check for negative \code{tim}.}
}
}
\note{
Potential name clash with function \link[units]{as_difftime}
}
