% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.R
\name{extract_ignore_x}
\alias{extract_ignore_x}
\title{Extractor function that ignores the x-axis and applies statistics over the
y-values.}
\usage{
extract_ignore_x(data)
}
\arguments{
\item{data}{Provided internally, users don't need to provide this.}
}
\value{
A 1-D numeric vector of y-values from the plot
}
\description{
Extractor function that ignores the x-axis and applies statistics over the
y-values.
}
\details{
For example this might be relevant for a mean per-base fastq
quality score. This will let you then calculate the overall mean quality of
the reads.
}
\examples{
report <- load_multiqc(
   system.file("extdata", "HG00096/multiqc_data.json", package = "TidyMultiqc"),
   sections = "plots",
   plot_opts = list(
     `fastqc_per_base_sequence_quality_plot` = list(
       extractor = extract_ignore_x,
       summary = list(mean = mean),
       prefix = "quality"
     )
   )
)
}
\seealso{
Other extractors: 
\code{\link{extract_histogram}()},
\code{\link{extract_xy}()}
}
\concept{extractors}
