% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_frailty.R
\name{post_frailty.AdPaik}
\alias{post_frailty.AdPaik}
\title{Posterior frailty estimates and variances for the 'Adapted Paik et al.'s Model'}
\usage{
post_frailty.AdPaik(optimal_params, dataset, time_to_event, centre, time_axis)
}
\arguments{
\item{optimal_params}{Optimal parameters estimated by maximizing the log-likelihood function, through the constraint
multi-dimensional optmization method.}

\item{dataset}{Dataset containing all the covariates/regressors.}

\item{time_to_event}{Time-instant, in the follow-up, in which an individual faces the event or fails.
If an individual does not face the event in the follow-up, then the time-instant must assume a default value.}

\item{centre}{Individual group/cluster membership.}

\item{time_axis}{Temporal domain.}
}
\value{
S3 object of class 'PF.AdPaik' composed of two elements of different class:
\itemize{
\item PosteriorFrailtyEst: S3 object of class 'PFE.AdPaik'.
\item PosteriorFrailtyVar: S3 object of class 'PFV.AdPaik'.
}
}
\description{
Function for computing the posterior frailty estimates and variances of the time-dependent shared frailty Cox model.
Recalling the structure of the frailty \eqn{Z_{jk} = \alpha_j + \epsilon_{jk}, \forall j,k} as being composed by the sum
of two independent gamma distributions:
\itemize{
\item \eqn{\alpha_j \sim gamma(\mu_1/\nu, 1/\nu), \forall j}
\item \eqn{\epsilon_{jk} \sin gamma(\mu_2/\gamma_k, 1/\gamma_k), \forall j,k}
the posterior distribution of both terms is still a gamma with different mean and variance and the
posterior frailty estimate corresponds to the 'empirical Bayes estimate', that is the previous mentioned posterior mean.
}
}
