% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betweenSubjects.R
\name{betweenSubjectMPT}
\alias{betweenSubjectMPT}
\title{Between-Subject Comparison of Parameters}
\usage{
betweenSubjectMPT(model1, model2, par1, par2 = par1, stat = c("x-y", "x<y"),
  plot = FALSE)
}
\arguments{
\item{model1}{fitted hierarchical MPT model for first between-subjects condition}

\item{model2}{fitted hierarchical MPT model for second between-subjects condition}

\item{par1}{label of parameter from first model for which statistic should be computed}

\item{par2}{label of parameter from second model. Default: The same parameter as in the first model}

\item{stat}{one or more functions of the parameters using \code{"x"} and \code{"y"} as placeholders for the parameters from the first and second model, respectively. Default: Compute (A) the difference between parameters and (B) a Bayesian p-value (by counting how often x<y).}

\item{plot}{whether to plot the convergence of the difference in parameters}
}
\value{
a list of the class \code{betweenMPT} with the values:
\itemize{
 \item \code{summary}: Summary for parameter difference
 \item \code{mptInfo1}, \code{mptInfo2}: info about MPT models (eqn and data file etc.)
 \item \code{mcmc}: the MCMC samples of the differences in parameters
}
}
\description{
Computes differencesor other statistics of MPT parameters for two hierarchical MPT models fitted separately to between-subjects data
}
\author{
Daniel Heck
}
