% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_path.R
\name{PathDist}
\alias{PathDist}
\title{Path distance}
\usage{
PathDist(tree1, tree2 = NULL)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on
\insertCite{Day1985;textual}{TreeDist}.}
}
\value{
\code{PathDist()} returns a vector or distance matrix of distances
between trees.
}
\description{
Calculate the path distance between rooted or unrooted trees.
}
\details{
This function is a faster alternative to the function
\code{\link[phangorn:treedist]{path.dist()}} in the phangorn package,
which can crash if the internal representation of trees does not conform to
certain (unspecified) expectations, and which treats all trees as unrooted.

The path distance is calculated by tabulating the cladistic difference (=
topological distance) between each pair of tips in each tree.
A precursor to the path distance \insertCite{Farris1969}{TreeDist}
took the mean squared
difference between the elements of each tree's tabulation (Farris, 1973);
the method used here is that proposed by
\insertCite{Steel1993;textual}{TreeDist}, which takes the square root of this
sum.
Other precursor measures are described in
\insertCite{Williams1971;textual}{TreeDist} and
\insertCite{Phipps1971;textual}{TreeDist}.

If a root node is present, trees are treated as rooted.
To avoid counting the root edge twice, use \code{UnrootTree(tree)} before
calculating the path distance.

Use of the path distance is discouraged as it emphasizes
shallow relationships at the expense of deeper (and arguably more
fundamental) relationships \insertCite{Farris1973}{TreeDist}.
}
\examples{
library("TreeTools")

# Treating the two edges to the root node as distinct
PathDist(BalancedTree(7), PectinateTree(7))

# Counting those two edges once
PathDist(UnrootTree(BalancedTree(7)), UnrootTree(PectinateTree(7)))

PathDist(BalancedTree(7), as.phylo(0:2, 7))
PathDist(as.phylo(0:2, 7), PectinateTree(7))

PathDist(list(bal = BalancedTree(7), pec = PectinateTree(7)),
        as.phylo(0:2, 7))

PathDist(as.phylo(30:33, 8))
 
}
\references{
\insertAllCited{}
}
\seealso{
Other tree distances: 
\code{\link{HierarchicalMutualInfo}()},
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NNIDist}()},
\code{\link{NyeSimilarity}()},
\code{\link{Robinson-Foulds}},
\code{\link{SPRDist}()},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
