#' Thirty Datasets with Inapplicable data
#' 
#' These are the datasets used to evaluate the behaviour of the inapplicable algorithm 
#' in Brazeau, Guillerme and Smith (2017).
#'
#' The name of each item corresponds to the datasets listed below.
#' Datasets are sorted into two subsets, each sorted alphabetically;
#' the first subset comprise simpler datasets with faster processing times.
#' The value is the dataset in the format generated by \code{\link{read.nexus.data}}.
#'
#' @template inapplicableSources
#'
#' @references
#'  \insertRef{Brazeau2018}{TreeSearch}
#' 
#' @keywords datasets
"inapplicable.datasets"

#' Thirty Datasets with Inapplicable data
#' 
#' These are the datasets used to evaluate the behaviour of the inapplicable algorithm 
#' in Brazeau, Guillerme and Smith (2017).
#'
#' The name of each item corresponds to the datasets listed below.
#' Datasets are sorted into two subsets, each sorted alphabetically;
#' the first subset comprise simpler datasets with faster processing times.
#' The value is the dataset in \code{phyDat} format.
#'
#' @template inapplicableSources
#'
#' @references
#'  \insertRef{Brazeau2018}{TreeSearch}
#'
#' @keywords datasets
"inapplicable.phyData"

#' Thirty Datasets with Inapplicable data
#' 
#' These are the datasets used to evaluate the behaviour of the inapplicable algorithm 
#' in Brazeau, Guillerme and Smith (2018).
#'
#' The name of each item corresponds to the datasets listed below.  The value gives its citation.
#'
#' @template inapplicableSources
#'
#' @references
#'  \insertRef{Brazeau2018}{TreeSearch}
#'
#' @keywords datasets
"inapplicable.citations"


#' Raw data from Zhang et al. 2016
#'
#' @template LoboMods
#'
#' @source 
#'  \insertRef{Zhang2016}{TreeSearch}
#' 
#' @keywords datasets
"Lobo.data"

#' Data from Zhang et al. 2016 in phyDat format
#'
#' @template LoboMods
#'
#' @source
#'  \insertRef{Zhang2016}{TreeSearch}
#' 
#' @keywords datasets
"Lobo.phy"

#' 100 simulated data matrices 
#'
#'  Contains the 100 simulated matrices generated by Congreve & Lamsdell (2016) using a 
#'  heterogeneous Markov-k model, generated from the \link{referenceTree} topology, with 
#'  all branches sharing an equal length.
#'
#' @format A list with 100 entries, each comprising a phyDat object of 55 characters for 22 taxa
#'
#' @references 
#'  \insertRef{Congreve2016}{TreeSearch}
#'  \insertRef{Congreve2016dd}{TreeSearch}
#' 
#' @examples 
#'   data('referenceTree')
#'   data('congreveLamsdellMatrices')
#'   \dontrun{ProfileScore(referenceTree,
#'    PrepareDataProfile(congreveLamsdellMatrices[[17]]))}
#'
#' @source \url{https://datadryad.org/resource/doi:10.5061/dryad.7dq0j}
#' 
#' @keywords datasets
"congreveLamsdellMatrices"

#' Tree topology for matrix simulation
#'
#' The tree topology used to generate the matrices in \code{\link{congreveLamsdellMatrices}} 
#' Congreve & Lamsdell (2016)
#'
#' @format A single phylogenetic tree saved as an object of class \code{phylo}
#'
#' @references 
#'  \insertRef{Congreve2016}{TreeSearch}
#'  \insertRef{Congreve2016dd}{TreeSearch}
#' 
#' @examples 
#'   data(referenceTree)
#'   plot(referenceTree)
#' 
#' @source \url{https://dx.doi.org/10.1111/pala.12236}
#' 
#' @keywords datasets
"referenceTree"

#' Brewer palettes
#'
#' A list of eleven Brewer palettes containing one to eleven colours that
#' are readily distinguished by colourblind viewers, followed by a twelfth
#' 12-colour palette adapted for colour blindness.
#'
#' @source {
#'   [ColourBrewer2.org](http://colorbrewer2.org/#type=diverging&scheme=RdYlBu&n=3)
#'   [Martin Krzywinski](http://mkweb.bcgsc.ca/colorblind/)
#' }
#'
#' @keywords datasets
"brewer"

#' Double factorials
#' 
#' A vector with pre-calculated values of double factorials up to 300!!,
#' and the logarithms of double factorials up to 50 000!!.
#' 
#' 301!! is too large to store as an integer; use `logDoubleFactorials` instead.
#' 
#' @concept Double factorial
#' @keywords datasets
"doubleFactorials"

#' Natural logarithms of double factorials
#' 
#' A vector with pre-calculated values of double factorials up to 50 000!!.
#' 
#' @concept Double factorial
#' @keywords datasets
"logDoubleFactorials"