% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fitch.R
\name{MorphyTreeLength}
\alias{MorphyTreeLength}
\alias{MorphyLength}
\alias{GetMorphyLength}
\alias{C_MorphyLength}
\title{Calculate parsimony score with inapplicable data}
\usage{
MorphyTreeLength(tree, morphyObj)

MorphyLength(parent, child, morphyObj, inPostorder = FALSE,
  nTaxa = mpl_get_numtaxa(morphyObj))

GetMorphyLength(parentOf, leftChild, rightChild, morphyObj)

C_MorphyLength(parentOf, leftChild, rightChild, morphyObj)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape]{phylo}}, with tip labels in the order generated by
\code{\link{RenumberTips}}, i.e. corresponding to the sequence of taxa
in the corresponding Morphy object.}

\item{morphyObj}{A morphy object, perhaps created with \code{\link{PhyDat2Morphy}}.}

\item{parent}{the first column of the edge matrix of a tree of class
\code{\link{phylo}}, i.e. \code{tree$edge[, 1]}}

\item{child}{the second column of the edge matrix of a tree of class
\code{\link{phylo}}, i.e. \code{tree$edge[, 2]}}

\item{parentOf}{integer vector containing, for each tip and each node in sequential order,
the integer index its parent node.  The root node should be its own parent.}

\item{leftChild}{integer vector containing, for each node, starting at the root and proceeding
in sequential order, the integer corresponding to its
left child.  Tip numbering begins at 0; the root node is numbered \kbd{nTip}.}

\item{rightChild}{integer vector containing, for each node, the index
of its right child.}

\item{parentOf}{For each node, numbered in postorder, the number of its parent node.}

\item{leftChild}{For each internal node, numbered in postorder, the number of its left
child node or tip.}

\item{rightChild}{For each internal node, numbered in postorder, the number of its right
child node or tip.}
}
\value{
The length of the tree (after weighting)
}
\description{
Calculate parsimony score with inapplicable data
}
\section{Functions}{
\itemize{
\item \code{MorphyLength}: Faster function that requires internal tree parameters

\item \code{GetMorphyLength}: Fastest function that requires internal tree parameters

\item \code{C_MorphyLength}: Direct call to C function. Use with caution.
}}

\seealso{
PhyDat2Morphy
}
\author{
Martin R. Smith

Martin R. Smith

Martin R. Smith
}
\keyword{internal}
