% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetResolution.R
\name{QuartetResolution}
\alias{QuartetResolution}
\title{Relationship between four taxa}
\usage{
QuartetResolution(trees, tips)
}
\arguments{
\item{trees}{A list of trees of class \code{phylo}, or a \code{multiPhylo} object.}

\item{tips}{Vector specifying four tips whose relationship should be
reported, in a format accepted by \code{\link[TreeTools]{KeepTip}()}.}
}
\value{
A vector specifying an integer, for each tree, which of \code{tips[-1]}
is most closely related to \code{tips[1]}.
}
\description{
Relationship between four taxa
}
\examples{
trees <- inapplicable.trees[["Vinther2008"]]
tips <- c("Lingula", "Halkieria", "Wiwaxia", "Acaenoplax")
QuartetResolution(trees, tips)
}
\seealso{
Other utility functions: 
\code{\link{ClusterStrings}()}
}
\concept{utility functions}
