% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPR.R
\name{AllSPR}
\alias{AllSPR}
\title{All SPR trees}
\usage{
AllSPR(parent, child, nEdge, notDuplicateRoot, edgeToBreak)
}
\arguments{
\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 1]}.}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 2]}.}

\item{nEdge}{integer specifying the number of edges of a tree of class \code{\link{phylo}}, i.e. \code{dim(tree$edge)[1]}}

\item{notDuplicateRoot}{logical vector of length \code{nEdge}, specifying for each
edge whether it is the second edge leading to the root (in which case
its breaking will be equivalent to breaking the other root edge...
except insofar as it moves the position of the root.)}

\item{edgeToBreak}{(optional) integer specifying the index of an edge to bisect/prune,
generated randomly if not specified.
Alternatively, set to \code{-1} to return a complete list
of all trees one step from the input tree.}
}
\value{
\code{AllSPR()} returns a list of edge matrices for all trees one SPR
rearrangement from the starting tree
}
\description{
All SPR trees
}
\author{
Martin R. Smith
}
