% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{StringToPhyDat}
\alias{StringToPhyDat}
\alias{StringToPhydat}
\title{String to phyDat}
\usage{
StringToPhyDat(string, tips, byTaxon = TRUE)

StringToPhydat(string, tips, byTaxon = TRUE)
}
\arguments{
\item{string}{a string of tokens, optionally containing whitespace, with no
terminating semi-colon.}

\item{tips, }{a character vector corresponding to the names (in order)
of each taxon in the matrix}

\item{byTaxon}{= TRUE, string is one TAXON's coding at a time; FALSE: one
CHARACTER's coding at a time}
}
\value{
This function returns a data matrix in \code{\link[phangorn]{phyDat}} format.
}
\description{
Converts a character string to a PhyDat object.
}
\examples{
morphy <- StringToPhyDat("-?01231230?-", c('Lion', 'Gazelle'), byTaxon=TRUE)
# encodes the following matrix:
# Lion     -?0123
# Gazelle  1230?-

}
\seealso{
\code{\link{phyDat}}

\itemize{
\item \code{\link{PhyToString}}
}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
