% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{TreesMatchingSplit}
\alias{TreesMatchingSplit}
\alias{LnTreesMatchingSplit}
\title{Number of trees matching a bipartition split}
\usage{
TreesMatchingSplit(A, B)

LnTreesMatchingSplit(A, B)
}
\arguments{
\item{A, B}{Number of taxa in each partition.}
}
\value{
\code{TreesMatchingSplit} returns a numeric specifying the number of trees
that are compatible with the given split.

\code{LnTreesMatchingSplit} gives the natural logarithm of this number.
}
\description{
Calculates the number of unrooted bifurcated trees that are consistent with
a bipartition split that divides taxa into groups of size \code{A} and \code{B}.
}
\section{Functions}{
\itemize{
\item \code{LnTreesMatchingSplit}: Logarithm of the number of trees matching a split.
}}

\examples{
TreesMatchingSplit(5, 6)
LnTreesMatchingSplit(5, 6)

}
\seealso{
Other split information functions: \code{\link{CharacterInformation}},
  \code{\link{SplitInformation}},
  \code{\link{UnrootedTreesMatchingSplit}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split information functions}
