% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_numbering.R
\name{Neworder}
\alias{Neworder}
\alias{NeworderPruningwise}
\alias{NeworderPhylo}
\title{Reorder edges of a phylogenetic tree}
\usage{
NeworderPruningwise(nTip, nNode, parent, child, nEdge)

NeworderPhylo(nTip, parent, child, nEdge, whichwise)
}
\arguments{
\item{nTip, nNode, nEdge}{Integer specifying the number of tips, nodes
and edges in the input tree.}

\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree[["edge"]][, 2]}.}

\item{`whichwise`}{Integer specifying whether to order edges (1)
cladewise; or (2) in postorder.}
}
\value{
\code{NeworderPruningwise} returns an integer vector specifying the
pruningwise order of edges within a tree.

\code{NeworderPhylo} returns an integer vector specifying the order
of edges under the ordering sequence specified by \code{whichwise}.
}
\description{
Wrappers for the C functions called by
\code{ape::\link[ape:reorder.phylo]{reorder.phylo}}.
These call the C functions directly, so are faster -- but don't perform
as many checks on user input.  Bad input could crash R.
}
\examples{
nTip <- 8L
tree <- BalancedTree(nTip)
edge <- tree[["edge"]]
pruningwise <- NeworderPruningwise(nTip, tree$Nnode, edge[, 1], edge[, 2],
                                   dim(edge)[1])
cladewise <- NeworderPhylo(nTip, edge[, 1], edge[, 2], dim(edge)[1], 1L)
postorder <- NeworderPhylo(nTip, edge[, 1], edge[, 2], dim(edge)[1], 2L)

tree[["edge"]] <- tree[["edge"]][pruningwise, ]

}
\seealso{
Other C wrappers: 
\code{\link{RenumberTree}()}
}
\author{
\itemize{
\item C algorithm: Emmanuel Paradis
\item R wrapper: Martin R. Smith
}
}
\concept{C wrappers}
\keyword{internal}
