\name{as.data.frame.list}
\alias{as.data.frame.list}
\title{Convert a list of vectors to a data frame.}
\usage{
  \method{as.data.frame}{list} (x, row.names = NULL,
    optional = FALSE, ...)
}
\arguments{
  \item{x}{a list to convert to a data frame.}

  \item{row.names}{a vector equal to \code{length(x)}
  corresponding to the row names.  If \code{NULL}, the row
  names will be set to \code{names(x)}.}

  \item{optional}{not used.}

  \item{...}{other parameters passed to
  \code{\link{data.frame}}.}
}
\value{
  a data frame.
}
\description{
  This function will convert a list of vectors to a data
  frame. This function will handle three different types of
  lists of vectors. First, if all the elements in the list
  are named vectors, the resulting data frame will have
  have a number of columns equal to the number of unique
  names across all vectors. In cases where some vectors do
  not have names in other vectors, those values will be
  filled with \code{NA}.
}
\details{
  The second case is when all the vectors are of the same
  length. In this case, the resulting data frame is
  equivalent to applying \code{rbind} across all elements.

  The third case handled is when there are varying vector
  lengths and not all the vectors are named. This condition
  should be avoided. However, the function will attempt to
  convert this list to a data frame. The resulting data
  frame will have a number of columns equal to the length
  of the longest vector. For vectors with length less than
  this will fill the row with \code{NA}s. Note that this
  function will print a warning if this condition occurs.
}
\examples{
test1 <- list( c(a='a',b='b',c='c'), c(a='d',b='e',c='f'))
    as.data.frame(test1)

    test2 <- list( c('a','b','c'), c(a='d',b='e',c='f'))
    as.data.frame(test2)

    test3 <- list('Row1'=c(a='a',b='b',c='c'), 'Row2'=c(var1='d',var2='e',var3='f'))
    as.data.frame(test3)

    \dontrun{
    #This will print a warning.
    test4 <- list('Row1'=letters[1:5], 'Row2'=letters[1:7], 'Row3'=letters[8:14])
    as.data.frame(test4)
    }

    test5 <- list(letters[1:10], letters[11:20])
    as.data.frame(test5)

    \dontrun{
    #This will throw an error.
    test6 <- list(list(letters), letters)
    as.data.frame(test6)
    }
}
\author{
  Jason Bryer
  \href{mailto:jason@bryer.org}{jason@bryer.org}
}
\references{
  \url{http://stackoverflow.com/questions/4227223/r-list-to-data-frame}
}

