% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_tagging.R
\name{growth_tagging}
\alias{growth_tagging}
\title{Growth from tagging data}
\usage{
growth_tagging(param, method, Linf_range = c(5, 600), time_unit = "year")
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \strong{L1}: length at tagging [cm],
  \item \strong{L2}: length at recapture [cm],
  \item \strong{delta_t}: time interval between tagging ang recapture
  (instead two vectors with \strong{t1} (age at tagging) and \strong{t2}
  (age at recapture) can be provided.
}}

\item{method}{indicating which of following methods should be applied: "GullandHolt"
or "Munro".}

\item{Linf_range}{two values indicating the lower and upper limits of the range,
in which the \link{optimise} searches for the Linf value with the best fit
(lowest CV value ),}

\item{time_unit}{indicating the unit of the time interval, either "year", "month",
"week", or "day"}
}
\value{
A list with the input parameters and following parameters:
\itemize{
 \item \strong{x}: independent variable used for regression analysis,
 \item \strong{y}: dependent variable used for regression analysis,
 \item \strong{reg_coeffs}: regression coefficients,
 \item \strong{r2}: r squared of regression analysis,
 \item \strong{Linf}: infinite length for investigated species in cm [cm],
 \item \strong{K}: growth coefficent for investigated species per year [1/year],
 \item \strong{conf_int_K}: confidence intervals of K (only if Gulland Holt method
     was applied).
}
}
\description{
This function estimates growth parameters from tagging data. Munro plot
   is applied
}
\details{
If Munro plot is applied the optimal Linf value is found by minimizing the coefficient
of variation (CV = sd(K)/mean(K)). For this iterative method the \link{optimise}
function is applied. The histogram of the individual K values allows to distinguish
potential differences in growth performance between individuals. t0 can not be
estimated by Munro plot, neither by the Gulland Holt method.
}
\examples{
# from Wolff (1984)
dat <- list(L1 = c(40,46,29,30,18,31,48,49,59,58,61,65,57,55),
   L2 = c(85,53,55,56,25,43,70,59,62,80,72,83,65,56),
   delta_t = c(289,26,84,77,14,38,89,38,28,149,89,74,38,21))
growth_tagging(param = dat, "Munro", time_unit = "day", Linf_range=c(80,120))
growth_tagging(param = dat, "GullandHolt", time_unit = "day")


# from Sparre and Venema (1999)
dat <- list(L1 = c(9.7,10.5,10.9,11.1,12.4,12.8,14.0,16.1,16.3,17.0,17.7),
   L2 = c(10.2,10.9,11.8,12.0,15.5,13.6,14.3,16.4,16.5,17.2,18.0),
   delta_t = c(53,33,108,102,272,48,53,73,63,106,111))
growth_tagging(param = dat, "Munro", time_unit = "day", Linf_range = c(10,40))
growth_tagging(param = dat, "GullandHolt", time_unit = "day")

}
\references{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.

Sparre, P., Venema, S.C., 1999. Introduction to tropical fish stock assessment.
Part 2. Excercises. FAO Fisheries Technical Paper, (306.2, Rev. 2). 94 p.

Wolff, M., 1984. Early setback for scallop culture in Peru.
}

