% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_gene_TIL_cor}
\alias{vis_gene_TIL_cor}
\title{Heatmap for Correlation between Gene and Tumor Immune Infiltration (TIL)}
\usage{
vis_gene_TIL_cor(
  Gene = "TP53",
  cor_method = "spearman",
  data_type = "mRNA",
  sig = c("B cell_TIMER", "T cell CD4+_TIMER", "T cell CD8+_TIMER", "Neutrophil_TIMER",
    "Macrophage_TIMER", "Myeloid dendritic cell_TIMER"),
  Plot = "TRUE",
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{cor_method}{correlation method}

\item{data_type}{choose gene profile type,
including "mRNA", "transcript", "protein", "mutation", "cnv", "methylation", "miRNA".}

\item{sig}{Immune Signature, default: result from TIMER}

\item{Plot}{output the plot directly, default 'TRUE'}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\description{
Heatmap for Correlation between Gene and Tumor Immune Infiltration (TIL)
}
\examples{
\dontrun{
p <- vis_gene_TIL_cor(Gene = "TP53")
}
}
