% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCmodel.R
\name{UC}
\alias{UC}
\title{UC}
\usage{
UC(
  y,
  u = NULL,
  model = "?/none/?/?",
  h = NA,
  outlier = NA,
  tTest = FALSE,
  criterion = "aic",
  periods = NA,
  verbose = FALSE,
  stepwise = FALSE,
  p0 = -9999.9,
  arma = TRUE
)
}
\arguments{
\item{y}{a time series to forecast (it may be either a numerical vector or
a time series object). This is the only input required. If a vector, the additional
input \code{periods} should be supplied compulsorily (see below).}

\item{u}{a matrix of external regressors included only in the observation equation. 
(it may be either a numerical vector or a time series object). If the output wanted 
to be forecast, matrix \code{u} should contain future values for inputs.}

\item{model}{the model to estimate. It is a single string indicating the type of 
model for each component. It allows two formats "trend/seasonal/irregular" or 
"trend/cycle/seasonal/irregular". The possibilities available for each component are:
\itemize{
\item Trend: ? / none / rw / irw / llt / dt; 

\item Seasonal: ? / none / equal / different;

\item Irregular: ? / none / arma(0, 0) / arma(p, q) - with p and q integer positive orders;
    
\item Cycles: ? / none / combination of positive or negative numbers. Positive numbers fix
the period of the cycle while negative values estimate the period taking as initial
condition the absolute value of the period supplied. Several cycles with positive or negative values are possible
and if a question mark is included, the model test for the existence of the cycles
specified. The following are valid examples with different meanings: 48, 48?, -48, -48?,
48+60, -48+60, -48-60, 48-60, 48+60?, -48+60?, -48-60?, 48-60?.
}}

\item{h}{forecast horizon. If the model includes inputs h is not used, the lenght of u is used instead.}

\item{outlier}{critical level of outlier tests. If NA it does not carry out any 
outlier detection (default). A positive value indicates the critical minimum
t test for outlier detection in any model during identification. Three types of outliers are
identified, namely Additive Outliers (AO), Level Shifts (LS) and Slope Change (SC).}

\item{tTest}{augmented Dickey Fuller test for unit roots used in stepwise algorithm (TRUE / FALSE). 
The number of models to search for is reduced, depending on the result of this test.}

\item{criterion}{information criterion for identification ("aic", "bic" or "aicc").}

\item{periods}{vector of fundamental period and harmonics required.}

\item{verbose}{intermediate results shown about progress of estimation (TRUE / FALSE).}

\item{stepwise}{stepwise identification procedure (TRUE / FALSE).}

\item{p0}{initial parameter vector for optimisation search.}

\item{arma}{check for arma models for irregular components (TRUE / FALSE).}
}
\value{
An object of class \code{UComp}. It is a list with fields including all the inputs and
        the fields listed below as outputs. All the functions in this package fill in
        part of the fields of any \code{UComp} object as specified in what follows (function 
        \code{UC} fills in all of them at once):

After running \code{UCmodel} or \code{UCestim}:
\itemize{
\item p:        Estimated parameters
\item v:        Estimated innovations (white noise in correctly specified models)
\item yFor:     Forecasted values of output
\item yForV:    Variance of forecasted values of output
\item criteria: Value of criteria for estimated model
\item iter:     Number of iterations in estimation
\item grad:     Gradient at estimated parameters
\item covp:     Covariance matrix of parameters
}

After running \code{UCvalidate}:
\itemize{
\item table: Estimation and validation table
}

After running \code{UCcomponents}:
\itemize{
\item comp:  Estimated components in matrix form
\item compV: Estimated components variance in matrix form
}

After running \code{UCfilter}, \code{UCsmooth} or  \code{UCdisturb}:
\itemize{
\item yFit:  Fitted values of output
\item yFitV: Variance of fitted values of output
\item a:     State estimates
\item P:     Variance of state estimates
\item aFor:  Forecasts of states
\item PFor:  Forecasts of states variances
}

After running \code{UCdisturb}:
\itemize{
\item eta: State perturbations estimates
\item eps: Observed perturbations estimates
}
}
\description{
Runs all relevant functions for UC modelling
}
\details{
\code{UC} is a function for modelling and forecasting univariate
time series according to Unobserved Components models (UC). 
It sets up the model with a number of control variables that
govern the way the rest of functions in the package work. It also estimates 
the model parameters by Maximum Likelihood, forecasts the data, performs smoothing,
estimates model disturbances, estimates components and shows statistical diagnostics.
Standard methods applicable to UComp objects are print, summary, plot,
fitted, residuals, logLik, AIC, BIC, coef, predict, tsdiag.
}
\examples{
y <- log(AirPassengers)
m1 <- UC(y)
m1 <- UC(y, model = "llt/different/arma(0,0)")
}
\seealso{
\code{\link{UC}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, \code{\link{UCsmooth}}, 
         \code{\link{UCdisturb}}, \code{\link{UCcomponents}},
         \code{\link{UChp}}
}
\author{
Diego J. Pedregal
}
