\name{Gibbs}
\alias{Gibbs}
\title{Generate a Gibbs object for Umacs Sampler function}
\description{
Creates a \code{Gibbs} object that is used to initialize
an R function that performs a Gibbs updating step within the
sampler function generated by \code{\link{Sampler}}.

The sampler is built using the Umacs function \code{\link{Sampler}};
and the arguments (\code{update} and \code{init}) are embedded in the sampler function.

}
\usage{
Gibbs(update, init)
}
\arguments{
  \item{update}{ An R function, with no arguments, that samples directly from a (fully) conditional distribution. May refer directly to variables that are specified in the code{link{Sampler}} function call. Must return the updated value.}
  \item{init}{ An R function that returns a (random) starting point for a Markov chain for the parameter. To be executed before the iteration loop (before each chain). }
}
\details{
\code{Gibbs} is to be used only within the \code{Sampler} function call.
The arguments of the update and init functions are ignored.
The body of the function can contain references to any parameters
that are defined in the \code{Sampler} function call, or to any
variables in an enclosing environment (such as the Global Environment).

The name of the parameter that is being updated is \emph{not} specified in the
Gibbs object (and not in any of the argument functions either);
a call \code{Gibbs} \emph{must} be associated with a parameter name within
a \code{Sampler} function call.

}
\value{
An object of class \code{Gibbs},
to be further processed by the Umacs function \code{Sampler}.

}
\references{Kerman, Jouni. Umacs: A Universal Markov Chain Sampler. Technical report, Columbia University, New York.}
\author{Jouni Kerman <jouni@kerman.com>}
\note{}
\seealso{\code{\link{Umacs}} and \code{\link{Sampler}} for examples on how to create sampler functions.}
\examples{}
\keyword{iteration}
