% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_sweep.R
\name{apply_sweep}
\alias{apply_sweep}
\alias{apply0}
\alias{sweep0}
\alias{msweep}
\title{Slight modifications of apply() and sweep()}
\usage{
apply0(X, MARGIN, FUN, ...)

sweep0(X, MARGIN, STATS, FUN, ...)

msweep(X, MARGIN, STATS, FUN, ...)
}
\arguments{
\item{X}{an array.}

\item{MARGIN}{apply0() : a vector giving the subscripts which the function will be applied over. sweep0(), msweep() : a vector of indices giving the extent(s) of x which correspond to STATS.}

\item{FUN}{the function to be applied. For msweep(), a function that receives the elements of X and list in order}

\item{...}{further arguments passed to or from other methods.}

\item{STATS}{the summary statistic array which is to be swept out. For msweep(), list of summary statistic array.}
}
\value{
If each call to FUN returns a vector of length n, then apply returns an array of dimension c(n, dim(X)[MARGIN]) if n > 1. If n equals 1, apply returns a scalar if MARGIN has length 0, a vector if MARGIN has length 1 and an array of dimension dim(X)[MARGIN] otherwise.
sweep0() and msweep() return an array with the same shape as x, but with the summary statistics swept out.
}
\description{
Slightly modified version of apply() and sweep(). apply0() and sweep0() are modificationd of apply() and sweep() so that they can be used when the length(MARGIN) is zero. 
msweep () is a modification of sweep () so that it can be used when function receives multiple summary statistic.
}
\examples{
set.seed(0)
A <- array(rnorm(24), dim = 4:2)
meanA0 <- apply0(A, numeric(0), mean)
meanA12 <- apply0(A, 1:2, mean)
sdA12 <- apply0(A, 1:2, sd)
ctrArray <- function(a,mu) return(a-mu)
sweep0(A, numeric(0), meanA0, ctrArray)
sweep0(A, 1:2, meanA12, ctrArray)
statsA12 <- list(meanA12, sdA12)
stdArray <- function(a,mu,sigma) return((a-mu)/sigma)
msweep(A, 1:2, statsA12, stdArray)
}
