% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_LpS.R
\name{lstsp}
\alias{lstsp}
\title{Main function for the low rank plus sparse structure VAR model}
\usage{
lstsp(
  data,
  lambda.1 = NULL,
  mu.1 = NULL,
  lambda.1.seq = NULL,
  mu.1.seq = NULL,
  lambda.2,
  mu.2,
  lambda.3,
  mu.3,
  alpha_L = 0.25,
  omega = NULL,
  h = NULL,
  step.size = NULL,
  tol = 1e-04,
  niter = 100,
  backtracking = TRUE,
  skip = 5,
  cv = FALSE,
  nfold = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{A n by p dataset matrix}

\item{lambda.1}{tuning parameter for sparse component for the first step}

\item{mu.1}{tuning parameter for low rank component for the first step}

\item{lambda.1.seq}{a sequence of lambda to the left segment for cross-validation, it's not mandatory to provide}

\item{mu.1.seq}{a sequence of mu to the left segment, low rank component tuning parameter}

\item{lambda.2}{tuning parameter for sparse for the second step}

\item{mu.2}{tuning parameter for low rank for the second step}

\item{lambda.3}{tuning parameter for estimating sparse components}

\item{mu.3}{tuning parameter for estimating low rank components}

\item{alpha_L}{a positive numeric value, indicating the restricted space of low rank component, default is 0.25}

\item{omega}{tuning parameter for information criterion, the larger of omega, the fewer final selected change points}

\item{h}{window size of the first rolling window step}

\item{step.size}{rolling step}

\item{tol}{tolerance for the convergence in the second screening step, indicates when to stop}

\item{niter}{the number of iterations required for FISTA algorithm}

\item{backtracking}{A boolean argument to indicate use backtrack to FISTA model}

\item{skip}{The number of observations need to skip near the boundaries}

\item{cv}{A boolean argument, indicates whether the user will apply cross validation to select tuning parameter, default is FALSE}

\item{nfold}{An positive integer, the number of folds for cross validation}

\item{verbose}{If is TRUE, then it will print all information about current step.}
}
\value{
A list object including 
\describe{
    \item{cp}{Final estimated change points}
    \item{sparse_mats}{Final estimated sparse components}
    \item{lowrank_mats}{Final estimated low rank components}
    \item{est_phi}{Final estimated model parameter, equals to sum of low rank and sparse components}
}
}
\description{
Main function for the low-rank plus sparse structure VAR model
}
\examples{
\donttest{
nob <- 100
p <- 15
brk <- c(50, nob+1)
rank <- c(1, 3)
signals <- c(-0.7, 0.8)
singular_vals <- c(1, 0.75, 0.5)
info_ratio <- rep(0.35, 2)
try <- simu_var(method = "LS", nob = nob, k = p, lags = 1, brk = brk, 
                sigma = as.matrix(diag(p)), signals = signals, 
                rank = rank, singular_vals = singular_vals, info_ratio = info_ratio, 
                sp_pattern = "off-diagonal", spectral_radius = 0.9)
data <- try$series

lambda1 = lambda2 = lambda3 <- c(2.5, 2.5)
mu1 = mu2 = mu3 <- c(15, 15)
fit <- lstsp(data, lambda.1 = lambda1, mu.1 = mu1, 
             lambda.2 = lambda2, mu.2 = mu2, 
             lambda.3 = lambda3, mu.3 = mu3, alpha_L = 0.25, 
             step.size = 5, niter = 20, skip = 5, 
             cv = FALSE, verbose = FALSE)
print(fit$cp)
}
}
