% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reml.R
\name{lmerG}
\alias{lmerG}
\title{Construct Variance-Covariance Matrix of Random Effects for Models Fitted by Function 'lmer'}
\usage{
lmerG(obj, cov = FALSE)
}
\arguments{
\item{obj}{(object) inheriting from class 'lmerMod'}

\item{cov}{(logical) TRUE = in case of non-zero covariances a block diagonal matrix will be constructed,
FALSE = a diagonal matrix with all off-diagonal element being equal to zero will be contructed}
}
\value{
(Matrix) representing the variance-covariance structure of random effects \eqn{G}
}
\description{
This function restricts the variance-covariance matrix of random effects \eqn{G} to be either
diagonal ('cov=FALSE') or to take any non-zero covariances into account (default, 'cov=TRUE').
}
\details{
This function is not intended to be called directly by users and therefore not exported!
}
\examples{
\dontrun{
library(lme4)
data(Orthodont)
Ortho <- Orthodont
Ortho$age2 <- Ortho$age - 11
Ortho$Subject <- factor(as.character(Ortho$Subject))
fit <-lmer(distance~Sex+Sex:age2+(age2|Subject), Ortho) 
G1 <- VCA:::lmerG(fit, cov=FALSE)
G2 <- VCA:::lmerG(fit, cov=TRUE)
G1[1:10,1:10]
G2[1:10,1:10]
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}

