% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{recode_ia}
\alias{recode_ia}
\title{Recode interest area IDs and/or interest area labels}
\usage{
recode_ia(data = data, IDs = NULL, Labels = NULL)
}
\arguments{
\item{data}{A data table object output by \code{\link{relabel_na}}.}

\item{IDs}{A named character vector specifying the desired interest area 
IDs and the corresponding existing IDs where the first element is the old
value and the second element is the new value.}

\item{Labels}{A named character vector specifying the desired interest area 
labels and the corresponding existing labels where the first element is the 
old value and the second element is the new value.}
}
\value{
A data table with the same dimensions as \code{data}.
}
\description{
\code{recode_ia} replaces existing interest area IDs and/or labels for both 
eyes. For subsequent data processing, it is important that the ID values range 
between 0 and 8 (with 0 representing Outside all predefined interest areas).
LEFT_INTEREST_AREA_ID, 
RIGHT_INTEREST_AREA_ID, LEFT_INTEREST_AREA_LABEL, and RIGHT_INTEREST_AREA_LABEL)
for cells containing NAs. If NA, the missing values in the ID columns are 
relabeled as 0 and missing values in the LABEL columns are relabeled as 'Outside'.
}
\examples{
\dontrun{
library(VWPre)
# To recode both IDs and Labels...
df <- recode_ia(data=dat, IDs=c("234"="2", "0"="0", "35"="3", "11"="1", "
4"="6666"), Labels=c(Outside="Dumb", Target="Targ", Dist2="Stupid", 
Comp="Comp", Dist1="Distractor1"))
}
}

