% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder.R
\name{FIC_reorder_univar}
\alias{FIC_reorder_univar}
\title{Univariate ordering under FIC approximation, first m chosen by m iter of
  dense univariate reordering}
\usage{
FIC_reorder_univar(
  a,
  b,
  m,
  locs = NULL,
  covName = NULL,
  covParms = NULL,
  covMat = NULL
)
}
\arguments{
\item{a}{lower bound vector for TMVN}

\item{b}{upper bound vector for TMVN}

\item{m}{Vecchia conditioning set size}

\item{locs}{location (feature) matrix n X d}

\item{covName}{covariance function name from the `GpGp` package}

\item{covParms}{parameters for `covName`}

\item{covMat}{dense covariance matrix, not needed when `locs` is not null}
}
\value{
a vector of new order based on FIC assumption and maxmin ordering
}
\description{
Univariate ordering under FIC approximation, first m chosen by m iter of
  dense univariate reordering
}
\examples{
library(VeccTMVN)
n1 <- 5
n2 <- 5
n <- n1 * n2
m <- 5
locs <- as.matrix(expand.grid((1:n1) / n1, (1:n2) / n2))
covparms <- c(2, 0.1, 0)
cov_name <- "matern15_isotropic"
a <- rep(-Inf, n)
b <- seq(from = -3, to = 3, length.out = n)
cat("The output order should be roughly 1 to ", n)
cat(FIC_reorder_univar(a, b, m, locs, cov_name, covparms))

}
