% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVineHessian.R
\name{RVineHessian}
\alias{RVineHessian}
\title{Hessian Matrix of the Log-Likelihood of an R-Vine Copula Model}
\usage{
RVineHessian(data, RVM)
}
\arguments{
\item{data}{An N x d data matrix (with uniform margins).}

\item{RVM}{An \code{\link[=RVineMatrix]{RVineMatrix()}} object including the structure, the
pair-copula families, and the parameters. \cr
Only the following copula
families are allowed in \code{RVM$family} \cr
\code{0} = independence copula \cr
\code{1} = Gaussian copula \cr
\code{2} = Student t copula (t-copula)\cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr
\code{5} = Frank copula \cr
\code{6} = Joe copula \cr
\code{13} = rotated Clayton copula (180 degrees; \verb{survival Clayton'') \\cr `14` = rotated Gumbel copula (180 degrees; }survival Gumbel'') \cr
\code{16} = rotated Joe copula (180 degrees; ``survival Joe'') \cr
\code{23} = rotated Clayton copula (90 degrees) \cr
`24` = rotated Gumbel copula (90 degrees) \cr
`26` = rotated Joe copula (90 degrees) \cr
`33` = rotated Clayton copula (270 degrees) \cr
`34` = rotated Gumbel copula (270 degrees) \cr
`36` = rotated Joe copula (270 degrees) \cr}
}
\value{
\item{hessian}{The calculated Hessian matrix of the log-likelihood
value of the R-vine copula model.}
\item{der}{The product of the gradient
vector with its transposed version.}
}
\description{
This function calculates the Hessian matrix of the log-likelihood of a
d-dimensional R-vine copula model with respect to the copula parameter and
evaluates it on a given copula data set.
}
\note{
The Hessian matrix is not available for R-vine copula models with two
parameter Archimedean copulas, i.e. BB1, BB6, BB7, BB8 and their rotated
versions.
}
\examples{

# define 5-dimensional R-vine tree structure matrix
Matrix <- c(5, 2, 3, 1, 4,
            0, 2, 3, 4, 1,
            0, 0, 3, 4, 1,
            0, 0, 0, 4, 1,
            0, 0, 0, 0, 1)
Matrix <- matrix(Matrix, 5, 5)

# define R-vine pair-copula family matrix
family <- c(0, 1, 3, 4, 4,
            0, 0, 3, 4, 1,
            0, 0, 0, 4, 1,
            0, 0, 0, 0, 3,
            0, 0, 0, 0, 0)
family <- matrix(family, 5, 5)

# define R-vine pair-copula parameter matrix
par <- c(0, 0.2, 0.9, 1.5, 3.9,
         0, 0, 1.1, 1.6, 0.9,
         0, 0, 0, 1.9, 0.5,
         0, 0, 0, 0, 4.8,
         0, 0, 0, 0, 0)
par <- matrix(par, 5, 5)

# define second R-vine pair-copula parameter matrix
par2 <- matrix(0, 5, 5)

# define RVineMatrix object
RVM <- RVineMatrix(Matrix = Matrix, family = family,
                   par = par, par2 = par2,
                   names = c("V1", "V2", "V3", "V4", "V5"))

# simulate a sample of size 300 from the R-vine copula model
set.seed(123)
simdata <- RVineSim(300, RVM)

# compute the Hessian matrix of the first row of the data
out2 <- RVineHessian(simdata[1,], RVM)
out2$hessian

}
\references{
Dissmann, J. F., E. C. Brechmann, C. Czado, and D. Kurowicka
(2013). Selecting and estimating regular vine copulae and application to
financial returns. Computational Statistics & Data Analysis, 59 (1), 52-69.

Schepsmeier, U. and J. Stoeber (2014)
Derivatives and Fisher information of bivariate copulas.
Statistical Papers, 55(2), 525-542.
online first: \url{https://link.springer.com/article/10.1007/s00362-013-0498-x}.

Web supplement: Derivatives and Fisher Information of bivariate copulas.
\url{https://mediatum.ub.tum.de/node?id=1119201}

Stoeber, J. and U. Schepsmeier (2013). Estimating standard errors in regular
vine copula models. Computational Statistics, 28 (6), 2679-2707
\url{https://link.springer.com/article/10.1007/s00180-013-0423-8#}.
}
\seealso{
\code{\link[=BiCopDeriv]{BiCopDeriv()}},
\code{\link[=BiCopDeriv2]{BiCopDeriv2()}},
\code{\link[=BiCopHfuncDeriv]{BiCopHfuncDeriv()}},
\code{\link[=BiCopHfuncDeriv2]{BiCopHfuncDeriv2()}}, \cr
\code{\link[=RVineMatrix]{RVineMatrix()}},
\code{\link[=RVineMLE]{RVineMLE()}},
\code{\link[=RVineGrad]{RVineGrad()}}
}
\author{
Ulf Schepsmeier, Jakob Stoeber
}
