% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadsStats-utils.R
\name{processPckg}
\alias{processPckg}
\title{main function to analyze a list of packages in a given time frame}
\usage{
processPckg(
  pckg.lst,
  t0 = lastyear.date(),
  t1 = today(),
  opts = list(),
  device = "PDF",
  dirSave = NULL
)
}
\arguments{
\item{pckg.lst}{list of packages to process}

\item{t0}{initial date, begining of the time period given in "YYYY-MM-DD" format}

\item{t1}{final date, ending of the time period given in "YYYY-MM-DD" format}

\item{opts}{a list of different options available for customizing the output}

\item{device}{string to select the output format: 'PDF'/'PNG'/'JPEG' or 'screen'}

\item{dirSave}{name of a valid directory where to save the file, eg. do not specify this argument or enter "." for using the current working directory}
}
\description{
main function to analyze a list of packages in a given time frame
}
\examples{
\donttest{
# device is set to "screen" so no files are generated and plots will appear on "screen"
# alternative to 'device' are "PDF"/"PNG"/"JPEG"
processPckg("ehelp", device="screen")
processPckg(c("ehelp","plotly","ggplot2"), "2001-01-01", device="screen")
processPckg(c("ehelp","plotly","ggplot2"), "2001-01-01", opts="nostatic", device="screen")
processPckg(c("ehelp","plotly","ggplot2"), "2001-01-01",
	opts=c("nostatic","nocombined","nointeractive"), device="screen")
}

}
