% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scal2freq.R
\name{scal2freqR}
\alias{scal2freqR}
\title{Scale to frequency by R}
\usage{
scal2freqR(wf, scale, delta)
}
\arguments{
\item{wf}{wavelet name}

\item{scale}{a scale}

\item{delta}{the sampling period.}
}
\value{
A vector of two numbers: frequency and period.
}
\description{
Scale to frequency by R
}
\examples{
delta <- 1 / 12 # monthly data
scales <- 2^(1:7)

for (wf in c("haar", "d4", "d6", "d8", "d16")[1:5]) {
  df1 <- scal2freqM(wf, scales, delta)
  df2 <- scal2freqR(wf, scales, delta)

  print(cbind(df1$frequency, df2$frequency))
}
}
