\name{tofListMetaData}
\alias{tofListMetaData}
\docType{data}
\title{Parsed TOF-MS Meta-Data}
\description{tofListMetaData is a data.frame containing string 
	values for experimental meta-data, with rows and columns 
	addressable by spectrumName and attributeName, respectively.
}
\details{Meta-data can also be addressed using spectrum and 
	attribute indices.  This option should be used with
	caution since data and meta-data can be reordered 
	independently during signal processing or statistical analysis. 

Values can be updated if desired when tofListMetaData 
	includes NAs due to missing optional parameter files.

Required meta-data attributes are parsed from required files.

\bold{Meta-data attributeNames include:}

\emph{acquisitionInfo.arrayBarcode} - Target (Bruker plate) identifier string, 
	includes target type and target serial number - Required \cr
\emph{acquisitionInfo.ionPolarity} - \dQuote{positive} or \dQuote{negative} - Required \cr
\emph{acquisitionInfo.refId} - Spectrum identifier, used for spectrum vector names in tofList and rows names in tofListMetaData (generated by concatenating strings: sampleInfo.sampleName, \dQuote{\_ }, and replicateNumber - Optional \cr
\emph{acquisitionInfo.sourceFile} - File name (with path) containing binary mass 
	spectrum data, (from directory structure) - Automatic \cr
\emph{acquisitionInfo.spotIndex} - Spot index on MALDI plate - Automatic \cr
\emph{acquisitionInfo.spotName} - Spot name on MALDI plate - Automatic \cr
\emph{adcGain.high} - Digitizer gain factor - Optional \cr
\emph{adcGain.low} - Linear detector voltage - Optional \cr
\emph{array.affinityType} - Capture agent used for purification of biofluid samples - Optional \cr	
\emph{deflector.mode} - 1 = linear, 2 = quadratic - Optional \cr
\emph{experiment.id} - Same as acquisitionInfo.refId - Optional \cr
\emph{instrument.instrumentType} - \dQuote{Ultraflex Series} (hard coded) - Automatic \cr
\emph{instrument.instrumentVendor} - Name of instrument vendor - Required \cr	
\emph{instrument.serial} - Instrument serial number - Required \cr
\emph{instrumentSpecificSettings.adcBandwidth} - Digitizer bandwith limit - Optional \cr
\emph{instrumentSpecificSettings.adcOffset} - Digitizer offset, depends on spectrum 
	type and gain factor - Optional \cr
\emph{instrumentSpecificSettings.adcScale} - Digitizer sensitivity, depends on gain 
	factor - Optional \cr
\emph{instrumentSpecificSettings.detectorBaseVoltage} - Detector base voltage, depends 
	on spectrum type - Optional \cr
\emph{instrumentSpecificSettings.laserIntensityBaseRange} - Minimum laser power - Optional \cr
\emph{instrumentSpecificSettings.laserShots} - Number of laser shots per spot - Required \cr
\emph{instrumentSpecificSettings.timeZero} - Intial time in counts (calculated) - Required \cr
\emph{instrumentSpecificSettings.TOFmode} - Spectrometer mode: LINEAR or REFLECTOR - Automatic \cr
\emph{instrumentSpecificSettings.warmingShots} - Number of warming laser shots - Optional \cr
\emph{laserIntensity.units} - \% (hard coded) - Automatic \cr
\emph{laserIntensity.value} - Maximum laser power, percent of full scale - Optional \cr
\emph{laserIntensityWarming.units} - \% (hard coded) - Automatic \cr
\emph{laserIntensityWarming.value} - Warming Laser power, percent of  full scale - Optional \cr
\emph{mass.units} - \dQuote{Da} (hard coded) - Automatic \cr
\emph{mass.value} - Low mass cut off for matrix suppression - Optional \cr
\emph{massCalibration.calibrationSpectrumFile} - Calibration folder name.  (If unavailable 
	\dQuote{?} is assigned as default) - Optional \cr
\emph{massCalibration.dateCalibrated} - Calibration date - Required \cr
\emph{massCalibration.equation} - \eqn{c1*((T0+(X-1)*Tdelta)/U)^2+c0*((T0+(X-1)*Tdelta)/U)+c2}
	(hard coded) - Automatic \cr
\emph{massEnd.units} - Mass units, \dQuote{Da} (hard coded) - Automatic \cr
\emph{massEnd.value} - Highest mass in acquisition range - Optional \cr
\emph{massStart.units} - Mass units, \dQuote{Da} (hard coded) - Automatic \cr
\emph{massStart.value} - Lowest mass in acquisition range  -  Optional \cr
\emph{param.c0} - linear coefficient in calibration equation - Required \cr
\emph{param.c1} - quadratic coefficient in calibration equation - Required \cr
\emph{param.c2} - constant term in calibration equation - Required \cr
\emph{param.Mode} - Calibration mode: 1 = linear, 2 = quadratic - Optional \cr
\emph{param.T0} - Digitizer delay in ns - Required \cr
\emph{param.TDelta} - Dwell time in ns - Required \cr
\emph{param.U} - Nanoseconds/milliseconds conversion factor, \dQuote{1e6} (hard coded) - Automatic \cr
\emph{replicateNumber} - Index of occurrence of sampleInfo.sampleName - Automatic \cr
\emph{sampleInfo.groupName} - Clinical group sample is associated with, used for classification 
	analysis - Optional \cr
\emph{sampleInfo.sampleDescription} - Additional sample description - Optional \cr
\emph{sampleInfo.sampleName} - Sample identifier (if missing, the directory name is used as the 
	default value) - Optional \cr
\emph{sampleInfo.sampleSource} - Laboratory where data was acquired (user supplied input 
	parameter:  ParserParams.dataSource) - Required \cr
\emph{software.version} - version of XACQ software - Required \cr
\emph{spottingInfo.spotProtocol} - Laser movement patern during data acquisition  - Optional \cr
\emph{timeOfFlightData.dateCreated} - Data file creation date (from date stamp on fid file) - 
	Automatic \cr
\emph{timeOfFlightData.domain} - Data domain, \dQuote{time} (hard coded) - Automatic \cr
\emph{timeOfFlightData.encoding} - Data encoding, \dQuote{base64} (hard coded) - Automatic \cr
\emph{timeOfFlightData.end} - Number of data points in spectra - Required \cr
\emph{timeOfFlightData.offset} - Initial value for offset of spectra, will be updated during 	
alignment procedure, \dQuote{0.0} (Hard coded) - Automatic \cr
\emph{timeOfFlightData.pairOrder} - Order of measurement pairs for TOF data, e.g., time - intensity,
	 \dQuote{t-int} (hard coded) - Automatic \cr
\emph{timeOfFlightData.scale} - Initial value for linear scale coefficient for spectra, updated 
	during alignment: \dQuote{1.0} (hard coded) - Automatic \cr
\emph{timeOfFlightData.start} - Index for onset of data acquisition, hard coded: \dQuote{1} - Automatic \cr
}
\examples{


## To access a value:

data(tofListMetaDataRun2)

sampleName <- tofListMetaData["Pool 8_1","sampleInfo.sampleName"];

## To update a value 

tofListMetaData[ "Pool 8_2", "sampleInfo.sampleDescription" ] <- "Pool";

## To update the tofListMetaData rownames (desirable if default 
## assignments were used due to missing sampleInfo.sampleNames):

newSpecNames<-list();
numSpec<-dim(tofListMetaData)[1];
for (i in 1:numSpec) { newSpecNames[i]<-paste("spec",i,sep="")};
row.names(tofListMetaData)<-newSpecNames;
}

\seealso{
\code{\link{WMBrukerParser}}, \code{\link{BrukerParser}},\code{\link{ParserParams}}, 
	\code{\link{ParseAndSave}}, \code{\link{tofList}}
}

\keyword{classes}