% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsrch_optim.R
\name{winsrch_optim}
\alias{winsrch_optim}
\alias{winsrch_optim.default}
\title{Find the optimal half-window width combination}
\usage{
winsrch_optim(dat_in, ...)

\method{winsrch_optim}{default}(dat_in, wins_in = NULL,
  control = list(factr = 1e+07, parscale = c(1, 10, 1)), lower = c(0.1,
  1, 0.1), upper = c(2, 15, 2), ...)
}
\arguments{
\item{dat_in}{input data object to use with weighted regression}

\item{...}{arguments passed to \code{\link{wrtdscv}}, \code{\link{wrtds}}, or \code{\link{getwts}}}

\item{wins_in}{starting list of window weights for initializing the search algorithm}

\item{control}{A list of control parameters passed to \code{\link[stats]{optim}} (see details in \code{\link[stats]{optim}} help file).  The value passed to \code{factr} controls the convergence behavior of the \code{"L-BFGS-B"} method.  Values larger than the default will generally speed up the optimization with a potential loss of precision. \code{parscale} describes the scaling values of the parameters.}

\item{lower}{vector of minimum half-window widths to evaluate}

\item{upper}{vector of maximum half-window widths to evaluate}
}
\value{
Some stuff
}
\description{
Find the optimal half-window width combination to use for weighted regression.
}
\details{
This function uses \code{\link[stats]{optim}} to minimize the error returned by \code{\link{wrtdscv}} for a given window combination.  The search algorithm uses the limited-memory modification of the BFGS quasi-Newton method to impose upper and lower limits on the optimization search. These limits can be changed using the \code{lower} and \code{upper} arguments.
}
\examples{
\dontrun{
# setup parallel backend
library(doParallel)
ncores <- detectCores() - 1  
registerDoParallel(cores = ncores)

# run search function - takes a while
res <- winsrch_optim(tidobjmean)
}
}
\seealso{
\code{\link{wrtdscv}}, \code{\link{winsrch_grid}}
}
