% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{ROCPlotPair2}
\alias{ROCPlotPair2}
\title{Compare two ROC plots.}
\usage{
ROCPlotPair2(nm1, frame1, xvar1, truthVar1, truthTarget1, nm2, frame2, xvar2,
  truthVar2, truthTarget2, title, ..., estimate_sig = TRUE,
  returnScores = FALSE, nrep = 100, parallelCluster = NULL)
}
\arguments{
\item{nm1}{name of first model}

\item{frame1}{data frame to get values from}

\item{xvar1}{name of the first independent (input or model) column in frame}

\item{truthVar1}{name of the dependent (output or result to be modeled) column in frame}

\item{truthTarget1}{value we consider to be positive}

\item{nm2}{name of second model}

\item{frame2}{data frame to get values from}

\item{xvar2}{name of the first independent (input or model) column in frame}

\item{truthVar2}{name of the dependent (output or result to be modeled) column in frame}

\item{truthTarget2}{value we consider to be positive}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{estimate_sig}{logical, if TRUE estimate and display significance of difference from AUC 0.5.}

\item{returnScores}{logical if TRUE return detailed permutedScores}

\item{nrep}{number of permutation repetitions to estimate p values.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}
}
\description{
Plot two receiver operating characteristic curves from different data frames.
}
\details{
Use this curve to compare model predictions to true outcome from two
data frames, each of which has its own model predictions and true outcome columns.
}
\examples{

set.seed(34903490)
x1 = rnorm(50)
x2 = rnorm(length(x1))
y = 0.2*x2^2 + 0.5*x2 + x1 + rnorm(length(x1))
frm = data.frame(x1=x1,x2=x2,yC=y>=as.numeric(quantile(y,probs=0.8)))
# WVPlots::ROCPlot(frm, "x1", "yC", TRUE, title="Example ROC plot")
# WVPlots::ROCPlot(frm, "x2", "yC", TRUE, title="Example ROC plot")
WVPlots::ROCPlotPair2('train',frm, "x1", "yC", TRUE,
                      'test', frm, "x2", "yC", TRUE,
                      title="Example ROC pair plot", estimate_sig = TRUE)

}
\seealso{
\code{\link{ROCPlot}}
}
