% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShadowPlot.R
\name{ShadowPlot}
\alias{ShadowPlot}
\title{Plot a Shadow Bar Plot}
\usage{
ShadowPlot(frm, condvar, refinevar, title, ..., ncol = 1)
}
\arguments{
\item{frm}{data frame to get values from.}

\item{condvar}{name of the primary conditioning variable (a categorical variable, controls x-axis).}

\item{refinevar}{name of the second or refining conditioning variable (also a categorical variable, controls faceting).}

\item{title}{title to place on plot.}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{ncol}{numeric: number of columns in facet_wrap.}
}
\value{
a ggplot2 bar chart counting examples grouped by condvar, faceted by refinevar.
}
\description{
Plot a bar chart of row counts conditioned on the categorical variable \code{condvar},
faceted on a second categorical variable, \code{refinevar}. Each faceted plot
also shows a "shadow plot" of the totals conditioned on \code{condvar} alone.
}
\details{
This plot enables comparisons of subpopulation totals across both
\code{condvar} and \code{refinevar} simultaneously.

By default, the facet plots are arranged in a single column. This can be changed
with the optional \code{ncol} argument.
}
\examples{

ShadowPlot(mtcars, "carb", "cyl",
           title = "Number of example cars by carb and cyl counts")

}
