% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GainCurve.R
\name{GainCurvePlotWithNotation}
\alias{GainCurvePlotWithNotation}
\title{Plot the cumulative gain curve of a sort-order with extra notation}
\usage{
GainCurvePlotWithNotation(
  frame,
  xvar,
  truthVar,
  title,
  gainx,
  labelfun,
  ...,
  estimate_sig = FALSE,
  large_count = 1000,
  model_color = "darkblue",
  wizard_color = "darkgreen",
  shadow_color = "darkgray",
  crosshair_color = "red",
  text_color = "black"
)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model score) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{gainx}{the point on the x axis corresponding to the desired label}

\item{labelfun}{a function to return a label for the marked point}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{estimate_sig}{logical, if TRUE compute significance}

\item{large_count}{numeric, upper bound target for number of plotting points}

\item{model_color}{color for the model curve}

\item{wizard_color}{color for the "wizard" (best possible) curve}

\item{shadow_color}{color for the shaded area under the curve}

\item{crosshair_color}{color for the annotation location lines}

\item{text_color}{color for the annotation text}
}
\description{
Plot the cumulative gain curve of a sort-order with extra notation.
}
\details{
This is the standard gain curve plot (see \code{\link{GainCurvePlot}}) with
a label attached to a particular value of x. The label is created by
a function \code{labelfun}, which takes as inputs the x and y coordinates
of a label and returns a string (the label).
}
\examples{

set.seed(34903490)
y = abs(rnorm(20)) + 0.1
x = abs(y + 0.5*rnorm(20))
frm = data.frame(model=x, value=y)
gainx = 0.10  # get the top 10\% most valuable points as sorted by the model
# make a function to calculate the label for the annotated point
labelfun = function(gx, gy) {
  pctx = gx*100
  pcty = gy*100

  paste("The top ", pctx, "\% most valuable points by the model\n",
        "are ", pcty, "\% of total actual value", sep='')
}
WVPlots::GainCurvePlotWithNotation(frm, "model", "value",
   title="Example Gain Curve with annotation",
   gainx=gainx,labelfun=labelfun)

}
\seealso{
\code{\link{GainCurvePlot}}
}
