% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_contour.R
\name{plotly_contour}
\alias{plotly_contour}
\title{Interactive Contour Plot.}
\usage{
plotly_contour(
  wblr_obj,
  main = "Contour Plot",
  xlab = "Eta",
  ylab = "Beta",
  showGrid = TRUE,
  col = "black",
  gridCol = "lightgray",
  signif = 3
)
}
\arguments{
\item{wblr_obj}{An object of class 'wblr'.}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{showGrid}{Show grid (TRUE) or hide grid (FALSE).}

\item{col}{Color of the model contour}

\item{gridCol}{Color of the grid.}

\item{signif}{Significant digits of results}
}
\value{
The function returns no value.
}
\description{
Interactive Contour Plot.
}
\examples{
library(WeibullR)
library(WeibullR.plotly)
failures<-c(30, 49, 82, 90, 96)
obj<-wblr.conf(wblr.fit(wblr(failures), method.fit = 'mle'), method.conf = 'lrb')
plotly_contour(obj)
}
