% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{computeDemand}
\alias{computeDemand}
\title{Computes the expected demand}
\usage{
computeDemand(campaign, price)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}

\item{price}{Price as number in [0; 1] where 0 is the minimal and 1 is the maximal price.}
}
\value{
Expected demand in number of persons.
}
\description{
Computes the expected demand for a given Word-of-Mouth campaign at a given price.
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
demand <- computeDemand(campaign, price = 0.5)
print(demand)

}
\seealso{
\code{\link{computeRoundDemand}} \code{\link{computeProfit}} \code{\link{computeConsumerSurplus}} \code{\link{computeOptimalPrice}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
