% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderAll.R
\name{renderAll}
\alias{renderAll}
\title{Read Word document and apply functions \code{\link[WordR]{body_add_flextables}},\code{\link[WordR]{renderInlineCode}},\code{\link[WordR]{addPlots}}.}
\usage{
renderAll(
  docxIn,
  docxOut,
  flextables = NULL,
  Plots = NULL,
  height = 6,
  width = 6,
  debug = F
)
}
\arguments{
\item{docxIn}{String of length one; path to Word file with bookmarks OR officer::rdocx object}

\item{docxOut}{String of length one; path for output Word file or NA}

\item{flextables}{Named list of flextables; Tables to be inserted into the Word file}

\item{Plots}{Named list of functions (or plots - for plots which are stored as objects e.g., ggplot) creating plots to be inserted into the Word file}

\item{height}{height of the plots in output in inches, either of length 1 (and will be recycled), or same length as Plots}

\item{width}{width of the plots in output in inches, either of length 1 (and will be recycled), or same length as Plots}

\item{debug}{Boolean of length one; If \code{True} then \code{\link[base]{browser}()} is called at the beginning of the function}
}
\value{
Path to the rendered Word file if the operation was successfull OR officer::rdocx object if docxOut is NA
}
\description{
Read Word document and apply functions \code{\link[WordR]{body_add_flextables}},\code{\link[WordR]{renderInlineCode}},\code{\link[WordR]{addPlots}}.
}
\examples{
library(flextable)
library(ggplot2)
ft_mtcars <- flextable(mtcars)
FT <- list(mtcars=ft_mtcars)
Plots <- list(mtcars1 = ggplot(mtcars, aes(x = wt, y = hp, col = as.factor(cyl))) + geom_point())
renderAll(docxIn=paste0(examplePath(), "templates/templateAll.docx"),
          docxOut=paste0(examplePath(), "results/templateAll2.docx"),
          flextables=FT,
          Plots=Plots)

}
