% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xAuxEmbed.r
\name{xAuxEmbed}
\alias{xAuxEmbed}
\title{Function to encode a file as a base64 string for embedding}
\usage{
xAuxEmbed(
file,
download.attribute = basename(file),
link.text = paste0("Download ", download.attribute)
)
}
\arguments{
\item{file}{a file to encode}

\item{download.attribute}{the download attribute specifying the target
to be downloaded instead of being explored. By default, it is the
filename of the input file. The filename of the downloaded file can be
different from the input file if provided differently}

\item{link.text}{the link text (the visible part of the hyperlink)}
}
\value{
a hyperlink in the form of: <a href="encoded base64 string"
download="download.attribute">"link.text"</a>
}
\description{
\code{xAuxEmbed} is supposed to encode a file as a base64 string for
embedding such as into the R markdown rendering html file. It returns a
hyperlink.
}
\note{
This auxiliary function helps embed a file into the R markdown
rendering html file for the download.
}
\examples{
# file <- system.file("DESCRIPTION",package="XGR")
# res <- xAuxEmbed(file)
}
\seealso{
\code{\link{xAuxEmbed}}
}
