% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{listsToObs}
\alias{listsToObs}
\title{Flatten nested list into a list of observations}
\usage{
listsToObs(l, urls, append.value = TRUE, as.equiv = TRUE, url.map = TRUE)
}
\arguments{
\item{l}{list. Should be the output from \link{nodesToList}.}

\item{urls}{character vector the same length as \code{l}. Each element should map element of \code{l} to an XML file.}

\item{append.value}{logical. Should the XML value be appended to the observation?}

\item{as.equiv}{logical. Should observations from two different files (but the same ancestory) have the same name returned?}

\item{url.map}{logical. If TRUE, the 'url_key' column will contain a condensed url identifier (for each observation)
and full urls will be stored in the "url_map" element. If FALSE, the full urls are included (for each observation) 
as a 'url' column and no "url_map" is included.}
}
\value{
A list where each element reflects one "observation".
}
\description{
This function flattens the nested list into a list of "observations" (that is, a list of matrices with one row).
The names of the list that is returned reflects the XML ancestory of each observation.
}
