\name{YPmodel.adlgrk}
\alias{YPmodel.adlgrk}
\alias{summary.YPmodel.adlgrk}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Adaptively weighted logrank test
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
A function to calculate p-value of the adaptive weighted logrank test.
}
\usage{

\method{YPmodel}{adlgrk}(data, Estimate, ...)
\method{summary}{YPmodel.adlgrk}(object, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{\dots}{ For S4 method only. }
  \item{data}{ A properly qualified filename where text data is to be saved, or a dataframe of input data set with three vectors: the event / censoring time (unite: year), the censoring indicator, and the group membership indicator. See the structure of sample data set \code{\link{gastric}} for instance.}
  \item{Estimate}{ A dataframe of estimation results, including 1) estimation of \eqn{\hat{\beta}}, 2) its confidential intervals and 3) the odds function of the control group \eqn{\hat{R}(t,\hat{\beta})}, generated by \code{\link{YPmodel.estimate}}. }
  \item{object}{ A dataframe of the two lack-of-fit tests, to test the hypothesis of equal distribution function in the two groups, generated by \code{\link{YPmodel.adlgrk}}. }

}
\value{
An object of class \code{YPmodel.adlgrk}, basically a list including elements
    \item{pval}{ p-value from adaptively weighted logrank test. }
}
\references{
%% ~put references to the literature/web site here ~
YANG, S. AND PRENTICE, R. L. (2010). Improved Logrank-Type Tests for Survival Data Using Adaptive Weights. Biometrics 66, 30-38.
}
\author{
%%  ~~who you are~~
Junlong Sun and Song Yang
}
\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{YPmodel}}, \code{\link{YPmodel.estimate}},
}
\examples{
    library(YPmodel)
    data(gastric)
    Adlgrk <- YPmodel.adlgrk(data=gastric)
    summary(Adlgrk)

    Estimate <- YPmodel.estimate(data=gastric, interval=0)
    Adlgrk <- YPmodel.adlgrk(data=gastric, Estimate=Estimate)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{YPmodel}
