\name{gpairs}
\alias{gpairs}
\alias{corrgram}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Generalized Pairs Plots }
\description{
Produces a matrix of plots showing pairwise relationships between quantitative and categorical variables in a complex data set.
}
\usage{
gpairs(x,
       upper.pars = list(scatter = "points",
                         conditional = "barcode",
                         mosaic = "mosaic"),
       lower.pars = list(scatter = "points",
                         conditional = "boxplot",
                         mosaic = "mosaic"),
       diagonal = "default",
       outer.margins = list(bottom = unit(2, "lines"), 
                            left = unit(2, "lines"), 
                            top = unit(2, "lines"), 
                            right = unit(2, "lines")), 
       xylim = NULL,
       outer.labels = NULL, outer.rot = c(90, 0), gap = 0.05, 
       buffer = 0.02, stat.pars = NULL, scatter.pars = NULL, 
       bwplot.pars = NULL, stripplot.pars = NULL, barcode.pars=NULL,
       mosaic.pars = NULL, axis.pars = NULL, diag.pars = NULL, 
       whatis = FALSE)

corrgram(x)
}
\arguments{
  \item{x}{a data frame (or matrix the relationships between whose columns are to be examined). Any combination of quantitative and categorical variables is acceptable.}
  \item{upper.pars}{see details}
  \item{lower.pars}{see details}
  \item{diagonal}{By default, the diagonal from the top left to the bottom right is used for displaying the variable names (and, in our version, the marginal distributions of the variables); \code{diagonal="other"} will place the diagonal running from the top right down to the bottom left.}
  \item{outer.margins}{a list of length 4 with units as components named bottom, left, top, and right, giving the outer margins; the default uses two lines of text.  A vector of length 4 with units (ordered properly) will work, as will a vector of length 4 with numeric values (interpreted as lines).}
  \item{xylim}{optionally specify a single range to be used as \code{xlim} and \code{ylim} where appropriate.  Note that if this option causes cropping, it will fail to work in barcode panels.}
  \item{outer.labels}{the default is \code{NULL}, for alternating axis labels around the perimeter.  If 'all', all labels are printed, and if 'none' no labels are printed.}
  \item{outer.rot}{a 2-vector (x, y) rotating the top/bottom outer labels x degrees and the left/right outer labels y degrees. Only works for categorical labels of boxplot and mosaic panels.}
  \item{gap}{the gap between the tiles; defaulting to 0.05 of the width of a tile.}
  \item{buffer}{the fraction by which to expand the range of quantitative variables to provide plots that will not truncate plotting symbols. Defaults to 0 percent of range currently.}
  \item{stat.pars}{\code{NULL} is equivalent to \code{list(fontsize = 7, signif = 0.05, verbose = FALSE)}; \code{stat.pars\$verbose} can be \code{TRUE} (providing 5 statistics), \code{FALSE} (providing 2 statistics), or \code{NA} (nothing).  This is only used with \code{scatter="stats")} in \code{upper.pars} and \code{lower.pars}.}
  \item{scatter.pars}{\code{NULL} is equivalent to \code{list(pch = 1, size = unit(0.25, 'char'), col = 'black', frame.fill = NULL, border.col = 'black')}.}
  \item{bwplot.pars}{\code{NULL}, passed to \code{bwplot} for producing boxplots.}
  \item{stripplot.pars}{\code{NULL} is equivalent to \code{list(pch = 1, size = unit(0.5, 'char'), col = 'black', jitter = FALSE)}.}
  \item{barcode.pars}{\code{NULL} is equivalent to \code{list(nint = 0, ptsize = unit(0.25, "char"), ptpch = 1, bcspace = NULL, use.points = FALSE)}.}
  \item{mosaic.pars}{\code{NULL}. Currently, only \code{shade} and \code{gp_labels} are passed through to \code{strucplot} for producing mosaic tiles.}
  \item{axis.pars}{\code{NULL} is equivalent to \code{list(n.ticks = 5, fontsize = 9)}.}
  \item{diag.pars}{\code{NULL} is equivalent to \code{list(fontsize = 9, show.hist = TRUE, hist.color = 'black')}.}
  \item{whatis}{default is \code{FALSE}; \code{TRUE} returns \code{whatis(x)}.}
}
\details{
In some cases, the graphics device can not be resized after production of the plot because of the way rotation of barcodes is performed.

\code{upper.pars} and \code{lower.pars} are lists possibly containing named elements 'scatter', 'conditional' and 'mosaic'. Each element of the list is a string implementing the following options: 'scatter' = exactly one of ('points', 'lm', 'ci', 'symlm', 'loess', 'corrgram', 'stats', 'qqplot'); 
'conditional' = exactly one of ('boxplot', 'stripplot',  'barcode'); \code{mosaic="mosaic"} (only option currently implemented).

\code{corrgram()} is just a wrapper to \code{gpairs()} producing a 'corrgram' in the style of Michael Friendly.

}
\value{
If \code{whatis=TRUE}, the value is a data frame containing variable names, types, numbers of missing values, numbers of distinct values, precisions, maxima and minima.
}
\references{
"Mosaic Displays in S-PLUS: A General Implementation and a Case Study."  John W. Emerson, Statistical Computing and Graphics Newsletter, Vol. 9,No. 1, 1998.

Graphical Analysis of Multiresponse Data:  Illustrated with a PlantBreeding Trial.  Basford, K.E. and Tukey, J.W. (1999).

Visualizing Categorical Data.  Michael Friendly (2000). SAS Press.

Friendly, M., 2002, 'Corrgrams: Exploratory displays for correlation matrices.' American Statistician 56(4), 316--324.
}
\author{John W. Emerson, Walton Green}
\seealso{\code{\link{pairs}}, \code{\link{splom}}, \code{\link{mosaicplot}}, \code{\link[vcd]{strucplot}}, \code{\link{bwplot}}, \code{\link{barcode}}, \code{\link{stripplot}}.}
\examples{

allexamples <- FALSE

y <- data.frame(A=c(rep("red", 100), rep("blue", 100)),
                B=c(rnorm(100),round(rnorm(100,5,1),1)), C=runif(200),
                D=c(rep("big", 150), rep("small", 50)),
                E=rnorm(200))
gpairs(y)

data(iris)
gpairs(iris)
if (allexamples) {
  gpairs(iris, upper.pars = list(scatter = 'stats'), scatter.pars = list(pch = substr(as.character(iris$Species), 1, 1), col = as.numeric(iris$Species)), stat.pars = list(verbose = FALSE))
  gpairs(iris, lower.pars = list(scatter = 'corrgram'), upper.pars = list(conditional = 'boxplot', scatter = 'loess'), scatter.pars = list(pch = 20))
}

data(Leaves)
gpairs(Leaves[1:10], lower.pars = list(scatter = 'loess'))
if (allexamples) {
  gpairs(Leaves[1:10], upper.pars = list(scatter = 'stats'), lower.pars = list(scatter = 'corrgram'), stat.pars = list(verbose = FALSE), gap = 0)
  corrgram(Leaves[,-33])
}

runexample <- FALSE
if (runexample) {
  data(NewHavenResidential)
  gpairs(NewHavenResidential)
}

}
\keyword{ts}
\keyword{multivariate}
