% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApplyZFunction.R
\name{ApplyZFunction}
\alias{ApplyZFunction}
\title{Function to apply the Zadeh's principle}
\usage{
ApplyZFunction(
  value,
  FUN,
  knots = 10,
  approximation = FALSE,
  method = "NearestEuclidean",
  ...
)
}
\arguments{
\item{value}{Input fuzzy number.}

\item{FUN}{Function used for the input fuzzy number with the help of the Zadeh's principle.}

\item{knots}{Number of the alpha-cuts used during calculation of the output.}

\item{approximation}{If \code{TRUE}, the approximated output is calculated.}

\item{method}{The selected approximation method.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is a fuzzy number described by
classes from \code{FuzzyNumbers} package (piecewise linear fuzzy number without approximation,
various types with the approximation applied).
}
\description{
\code{ApplyZFunction} applies the selected function to a fuzzy number using the Zadeh's principle.
}
\details{
The function takes the input fuzzy number \code{value} (which should be described by one of the
classes from \code{FuzzyNumbers} package) and applies the function \code{FUN} using
the Zadeh's principle. The output is given by a fuzzy number or its approximation (when
\code{approximation} is set to \code{TRUE} and the respective \code{method} is selected).
To properly find the output, value of \code{FUN} is calculated for many alpha-cuts of \code{value}.
The number of these alpha-cuts is equal to \code{knots} (plus 2 for the support and the core).

The input fuzzy number \code{value} should be given by fuzzy number described by classes from \code{FuzzyNumbers} package.
}
\examples{

library(FuzzyNumbers)

# prepare complex fuzzy number

A <- FuzzyNumber(-5, 3, 6, 20, left=function(x)
pbeta(x,0.4,3),
right=function(x) 1-x^(1/4),
lower=function(alpha) qbeta(alpha,0.4,3),
upper=function(alpha) (1-alpha)^4)

# find the output via the Zadeh's principle

ApplyZFunction(A,FUN=function(x)x^3+2*x^2-1)

# find the approximated output via the Zadeh's principle

ApplyZFunction(A,FUN=function(x)x^3+2*x^2-1,approximation=TRUE)


}
