% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{qi_slimmer}
\alias{qi_slimmer}
\title{Find the median and a central interval of simulated quantity of interest
distributions}
\usage{
qi_slimmer(df, qi_type = "ev", ci = 0.95)
}
\arguments{
\item{df}{a tidy-formatted data frame of simulated quantities of interest
created by \code{\link{zelig_qi_to_df}}.}

\item{qi_type}{character string either \code{ev} or \code{pv} for returning the
central intervals for the expected value or predicted value, respectively.}

\item{ci}{numeric. The central interval to return, expressed on the
\code{(0, 100]} or the equivalent \code{(0, 1]} interval.}
}
\description{
Find the median and a central interval of simulated quantity of interest
distributions
}
\examples{
library(dplyr)
qi.central.interval <- zelig(Petal.Width ~ Petal.Length + Species,
             data = iris, model = "ls") \%>\%
             setx(Petal.Length = 2:4, Species = "setosa") \%>\%
             sim() \%>\%
             zelig_qi_to_df() \%>\%
             qi_slimmer()

}
\seealso{
\code{\link{zelig_qi_to_df}}
}
\author{
Christopher Gandrud
}
