library(testthat)
data(APEXMS)

# apexFeatures.default
test_that("apexFeatures.default", {
	expect_that(apexFeatures.default(data.frame()),throws_error())

	expect_that(apexFeatures.default(head(APEX_ORBI,20)),equals(structure(list(peptide_sequence = c("MASTDFSKIETLKQLNASLADK", "IETLKQLNASLADKSYIEGTAVSQADVTVFK", "QLNASLADKSYIEGTAVSQADVTVFKAFQSAYPEFSR", "SYIEGTAVSQADVTVFKAFQSAYPEFSRWFNHIASK", "AFQSAYPEFSRWFNHIASKADEFDSFPAASAAAAEEEEDDDVDLFGSDDEEADAEAEK", "WFNHIASKADEFDSFPAASAAAAEEEEDDDVDLFGSDDEEADAEAEKLK", "ADEFDSFPAASAAAAEEEEDDDVDLFGSDDEEADAEAEKLKAER", "LKAERIAAYNAK", "AERIAAYNAKK", "IAAYNAKKAAKPAKPAAK", "KAAKPAKPAAKSIVTLDVKPWDDETNLEEMVANVK", "AAKPAKPAAKSIVTLDVKPWDDETNLEEMVANVKAIEMEGLTWGAHQFIPIGFGIK", "SIVTLDVKPWDDETNLEEMVANVKAIEMEGLTWGAHQFIPIGFGIKK", "AIEMEGLTWGAHQFIPIGFGIKKLQINCVVEDDK", "KLQINCVVEDDKVSLDDLQQSIEEDEDHVQSTDIAAMQK", "LQINCVVEDDKVSLDDLQQSIEEDEDHVQSTDIAAMQKL", "MASTDFSKIETLK", "IETLKQLNASLADK", "QLNASLADKSYIEGTAVSQADVTVFK", "SYIEGTAVSQADVTVFKAFQSAYPEFSR"), apex = structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L), .Label = c("0", "1"), class = "factor"), length = c(22L, 31L, 37L, 36L, 58L, 49L, 44L, 12L, 11L, 18L, 35L, 56L, 47L, 34L, 39L, 39L, 13L, 14L, 26L, 28L), A_sum = c(3, 4, 6, 5, 13, 11, 11, 4, 4, 8, 6, 8, 3, 2, 2, 2, 1, 2, 4, 4), R_sum = c(0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1), N_sum = c(1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 0, 1, 1, 0), D_sum = c(2, 2, 2, 1, 9, 9, 9, 0, 0, 0, 3, 3, 3, 2, 7, 7, 1, 1, 2, 1), C_sum = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0), Q_sum = c(1, 2, 3, 2, 1, 0, 0, 0, 0, 0, 0, 1, 1, 2, 5, 5, 0, 1, 2, 2), E_sum = c(1, 2, 2, 2, 10, 9, 10, 1, 1, 0, 3, 5, 5, 3, 4, 4, 1, 1, 1, 2), G_sum = c(0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 4, 4, 4, 0, 0, 0, 0, 1, 1), H_sum = c(0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0), I_sum = c(1, 2, 1, 2, 1, 1, 0, 1, 1, 1, 1, 5, 5, 5, 3, 3, 1, 1, 1, 1), L_sum = c(3, 3, 2, 0, 1, 2, 2, 1, 0, 0, 2, 3, 3, 2, 3, 4, 1, 3, 2, 0), K_sum = c(3, 3, 2, 2, 2, 3, 2, 2, 2, 5, 6, 6, 4, 3, 3, 2, 2, 2, 2, 1), M_sum = c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 1, 1, 1, 1, 0, 0, 0), F_sum = c(1, 1, 3, 4, 6, 4, 3, 0, 0, 0, 0, 2, 2, 2, 0, 0, 1, 0, 1, 3), P_sum = c(0, 0, 1, 1, 2, 1, 1, 0, 0, 2, 3, 4, 2, 1, 0, 0, 0, 0, 0, 1), S_sum = c(3, 3, 5, 5, 6, 4, 3, 0, 0, 0, 1, 1, 1, 0, 3, 3, 2, 1, 3, 4), T_sum = c(2, 3, 2, 2, 0, 0, 0, 0, 0, 0, 2, 3, 3, 1, 1, 1, 2, 1, 2, 2), W_sum = c(0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0, 0), Y_sum = c(0, 1, 2, 2, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2), V_sum = c(0, 3, 3, 3, 1, 1, 1, 0, 0, 0, 4, 4, 4, 2, 4, 4, 0, 0, 3, 3), A_avg = c(0.136363636363636, 0.129032258064516, 0.162162162162162, 0.138888888888889, 0.224137931034483, 0.224489795918367, 0.25, 0.333333333333333, 0.363636363636364, 0.444444444444444, 0.171428571428571, 0.142857142857143, 0.0638297872340425, 0.0588235294117647, 0.0512820512820513, 0.0512820512820513, 0.0769230769230769, 0.142857142857143, 0.153846153846154, 0.142857142857143), R_avg = c(0, 0, 0.027027027027027, 0.0277777777777778, 0.0172413793103448, 0, 0.0227272727272727, 0.0833333333333333, 0.0909090909090909, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0357142857142857), N_avg = c(0.0454545454545455, 0.032258064516129, 0.027027027027027, 0.0277777777777778, 0.0172413793103448, 0.0204081632653061, 0, 0.0833333333333333, 0.0909090909090909, 0.0555555555555556, 0.0571428571428571, 0.0357142857142857, 0.0425531914893617, 0.0294117647058824, 0.0256410256410256, 0.0256410256410256, 0, 0.0714285714285714, 0.0384615384615385, 0), D_avg = c(0.0909090909090909, 0.0645161290322581, 0.0540540540540541, 0.0277777777777778, 0.155172413793103, 0.183673469387755, 0.204545454545455, 0, 0, 0, 0.0857142857142857, 0.0535714285714286, 0.0638297872340425, 0.0588235294117647, 0.179487179487179, 0.179487179487179, 0.0769230769230769, 0.0714285714285714, 0.0769230769230769, 0.0357142857142857), C_avg = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0294117647058824, 0.0256410256410256, 0.0256410256410256, 0, 0, 0, 0), Q_avg = c(0.0454545454545455, 0.0645161290322581, 0.0810810810810811, 0.0555555555555556, 0.0172413793103448, 0, 0, 0, 0, 0, 0, 0.0178571428571429, 0.0212765957446809, 0.0588235294117647, 0.128205128205128, 0.128205128205128, 0, 0.0714285714285714, 0.0769230769230769, 0.0714285714285714), E_avg = c(0.0454545454545455, 0.0645161290322581, 0.0540540540540541, 0.0555555555555556, 0.172413793103448, 0.183673469387755, 0.227272727272727, 0.0833333333333333, 0.0909090909090909, 0, 0.0857142857142857, 0.0892857142857143, 0.106382978723404, 0.0882352941176471, 0.102564102564103, 0.102564102564103, 0.0769230769230769, 0.0714285714285714, 0.0384615384615385, 0.0714285714285714), G_avg = c(0, 0.032258064516129, 0.027027027027027, 0.0277777777777778, 0.0172413793103448, 0.0204081632653061, 0.0227272727272727, 0, 0, 0, 0, 0.0714285714285714, 0.0851063829787234, 0.117647058823529, 0, 0, 0, 0, 0.0384615384615385, 0.0357142857142857), H_avg = c(0, 0, 0, 0.0277777777777778, 0.0172413793103448, 0.0204081632653061, 0, 0, 0, 0, 0, 0.0178571428571429, 0.0212765957446809, 0.0294117647058824, 0.0256410256410256, 0.0256410256410256, 0, 0, 0, 0), I_avg = c(0.0454545454545455, 0.0645161290322581, 0.027027027027027, 0.0555555555555556, 0.0172413793103448, 0.0204081632653061, 0, 0.0833333333333333, 0.0909090909090909, 0.0555555555555556, 0.0285714285714286, 0.0892857142857143, 0.106382978723404, 0.147058823529412, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 0.0714285714285714, 0.0384615384615385, 0.0357142857142857), L_avg = c(0.136363636363636, 0.0967741935483871, 0.0540540540540541, 0, 0.0172413793103448, 0.0408163265306122, 0.0454545454545455, 0.0833333333333333, 0, 0, 0.0571428571428571, 0.0535714285714286, 0.0638297872340425, 0.0588235294117647, 0.0769230769230769, 0.102564102564103, 0.0769230769230769, 0.214285714285714, 0.0769230769230769, 0), K_avg = c(0.136363636363636, 0.0967741935483871, 0.0540540540540541, 0.0555555555555556, 0.0344827586206897, 0.0612244897959184, 0.0454545454545455, 0.166666666666667, 0.181818181818182, 0.277777777777778, 0.171428571428571, 0.107142857142857, 0.0851063829787234, 0.0882352941176471, 0.0769230769230769, 0.0512820512820513, 0.153846153846154, 0.142857142857143, 0.0769230769230769, 0.0357142857142857), M_avg = c(0.0454545454545455, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0285714285714286, 0.0357142857142857, 0.0425531914893617, 0.0294117647058824, 0.0256410256410256, 0.0256410256410256, 0.0769230769230769, 0, 0, 0), F_avg = c(0.0454545454545455, 0.032258064516129, 0.0810810810810811, 0.111111111111111, 0.103448275862069, 0.0816326530612245, 0.0681818181818182, 0, 0, 0, 0, 0.0357142857142857, 0.0425531914893617, 0.0588235294117647, 0, 0, 0.0769230769230769, 0, 0.0384615384615385, 0.107142857142857), P_avg = c(0, 0, 0.027027027027027, 0.0277777777777778, 0.0344827586206897, 0.0204081632653061, 0.0227272727272727, 0, 0, 0.111111111111111, 0.0857142857142857, 0.0714285714285714, 0.0425531914893617, 0.0294117647058824, 0, 0, 0, 0, 0, 0.0357142857142857), S_avg = c(0.136363636363636, 0.0967741935483871, 0.135135135135135, 0.138888888888889, 0.103448275862069, 0.0816326530612245, 0.0681818181818182, 0, 0, 0, 0.0285714285714286, 0.0178571428571429, 0.0212765957446809, 0, 0.0769230769230769, 0.0769230769230769, 0.153846153846154, 0.0714285714285714, 0.115384615384615, 0.142857142857143), T_avg = c(0.0909090909090909, 0.0967741935483871, 0.0540540540540541, 0.0555555555555556, 0, 0, 0, 0, 0, 0, 0.0571428571428571, 0.0535714285714286, 0.0638297872340425, 0.0294117647058824, 0.0256410256410256, 0.0256410256410256, 0.153846153846154, 0.0714285714285714, 0.0769230769230769, 0.0714285714285714), W_avg = c(0, 0, 0, 0.0277777777777778, 0.0172413793103448, 0.0204081632653061, 0, 0, 0, 0, 0.0285714285714286, 0.0357142857142857, 0.0425531914893617, 0.0294117647058824, 0, 0, 0, 0, 0, 0), Y_avg = c(0, 0.032258064516129, 0.0540540540540541, 0.0555555555555556, 0.0172413793103448, 0, 0, 0.0833333333333333, 0.0909090909090909, 0.0555555555555556, 0, 0, 0, 0, 0, 0, 0, 0, 0.0384615384615385, 0.0714285714285714), V_avg = c(0, 0.0967741935483871, 0.0810810810810811, 0.0833333333333333, 0.0172413793103448, 0.0204081632653061, 0.0227272727272727, 0, 0, 0, 0.114285714285714, 0.0714285714285714, 0.0851063829787234, 0.0588235294117647, 0.102564102564103, 0.102564102564103, 0, 0, 0.115384615384615, 0.107142857142857), FASG760101_sum = c(2790.03, 3881.19, 4688.95, 4714.03, 7419.31, 6214.13, 5496.3, 1545.72, 1414.55, 2118.41, 4420.89, 7068.85, 6100.76, 4395.92, 5115.37, 5100.35, 1686.86, 1777.95, 3206.41, 3585.78), FASG760101_avg = c(126.819545454545, 125.199677419355, 126.728378378378, 130.945277777778, 127.919137931035, 126.818979591837, 124.915909090909, 128.81, 128.595454545455, 117.689444444444, 126.311142857143, 126.229464285714, 129.803404255319, 129.291764705882, 131.163333333333, 130.778205128205, 129.758461538462, 126.996428571429, 123.323461538462, 128.063571428571), CHOP780201_sum = c(24.31, 33.25, 38.96, 37.29, 66.96, 57.83, 53.43, 14.14, 12.93, 20.74, 38.79, 60.76, 50.2, 35.87, 43.05, 43.1, 14.33, 15.77, 27.46, 28.98), CHOP780201_avg = c(1.105, 1.07258064516129, 1.05297297297297, 1.03583333333333, 1.15448275862069, 1.18020408163265, 1.21431818181818, 1.17833333333333, 1.17545454545455, 1.15222222222222, 1.10828571428571, 1.085, 1.06808510638298, 1.055, 1.10384615384615, 1.10512820512821, 1.10230769230769, 1.12642857142857, 1.05615384615385, 1.035), CHOP780202_sum = c(20.71, 32.07, 37.21, 37.36, 46.69, 38.39, 32.09, 11.36, 10.06, 15.4, 32.13, 54.12, 47.39, 35.14, 37.58, 38.14, 12.43, 13.48, 26.87, 28.93), CHOP780202_avg = c(0.941363636363636, 1.03451612903226, 1.00567567567568, 1.03777777777778, 0.804999999999999, 0.783469387755102, 0.729318181818182, 0.946666666666667, 0.914545454545454, 0.855555555555556, 0.918, 0.966428571428571, 1.00829787234043, 1.03352941176471, 0.963589743589744, 0.977948717948718, 0.956153846153846, 0.962857142857143, 1.03346153846154, 1.03321428571429), CHOP780203_sum = c(21.68, 29.65, 36.84, 35.3, 60.08, 50.49, 45.69, 10.87, 10.37, 18.06, 35.01, 53.98, 44.78, 32.06, 38.8, 38.11, 12.64, 13.13, 25.56, 27.8), CHOP780203_avg = c(0.985454545454545, 0.956451612903226, 0.995675675675676, 0.980555555555556, 1.03586206896552, 1.03040816326531, 1.03840909090909, 0.905833333333333, 0.942727272727273, 1.00333333333333, 1.00028571428571, 0.963928571428572, 0.952765957446808, 0.942941176470588, 0.994871794871795, 0.977179487179487, 0.972307692307692, 0.937857142857143, 0.983076923076923, 0.992857142857143), WERD780101_sum = c(11.34, 16.21, 19.55, 19.99, 29.52, 24.63, 21.06, 6.19, 5.42, 8.26, 17.2, 29.71, 25.79, 19.16, 19.95, 20.41, 6.82, 7.15, 13.58, 15.03), WERD780101_avg = c(0.515454545454545, 0.522903225806452, 0.528378378378378, 0.555277777777778, 0.508965517241379, 0.50265306122449, 0.478636363636363, 0.515833333333333, 0.492727272727273, 0.458888888888889, 0.491428571428571, 0.530535714285714, 0.548723404255319, 0.563529411764706, 0.511538461538461, 0.523333333333333, 0.524615384615385, 0.510714285714286, 0.522307692307692, 0.536785714285714), ZIMJ680104_sum = c(130.58, 180.9, 216.19, 214.79, 299.06, 248.87, 217.04, 80.53, 74.55, 126.39, 212.58, 332.75, 270.67, 198.18, 208.07, 204.31, 77.37, 83.83, 150.28, 162.98), ZIMJ680104_avg = c(5.93545454545455, 5.83548387096774, 5.84297297297297, 5.96638888888889, 5.15620689655173, 5.07897959183674, 4.93272727272727, 6.71083333333333, 6.77727272727273, 7.02166666666667, 6.07371428571428, 5.94196428571429, 5.75893617021277, 5.82882352941177, 5.33512820512821, 5.23871794871795, 5.95153846153846, 5.98785714285714, 5.78, 5.82071428571429), KLEP840101_sum = c(0, -1, -1, 0, -16, -15, -16, 2, 2, 5, 0, -2, -4, -2, -8, -9, 0, 0, -1, -1), KLEP840101_avg = c(0, -0.032258064516129, -0.027027027027027, 0, -0.275862068965517, -0.306122448979592, -0.363636363636364, 0.166666666666667, 0.181818181818182, 0.277777777777778, 0, -0.0357142857142857, -0.0851063829787234, -0.0588235294117647, -0.205128205128205, -0.230769230769231, 0, 0, -0.0384615384615385, -0.0357142857142857), EISD860102_sum = c(39.49, 48.43, 56.57, 55.66, 90.11, 76.27, 76.65, 29.7, 28.7, 33.16, 64.39, 86.46, 74.7, 52.5, 68.47, 63.77, 25.96, 25.93, 36.03, 43.04), EISD860102_avg = c(1.795, 1.56225806451613, 1.52891891891892, 1.54611111111111, 1.55362068965517, 1.5565306122449, 1.74204545454545, 2.475, 2.60909090909091, 1.84222222222222, 1.83971428571429, 1.54392857142857, 1.58936170212766, 1.54411764705882, 1.75564102564103, 1.6351282051282, 1.99692307692308, 1.85214285714286, 1.38576923076923, 1.53714285714286), FAUJ880111_sum = c(3, 3, 3, 4, 4, 4, 3, 3, 3, 5, 6, 7, 5, 4, 4, 3, 2, 2, 2, 2), FAUJ880111_avg = c(0.136363636363636, 0.0967741935483871, 0.0810810810810811, 0.111111111111111, 0.0689655172413793, 0.0816326530612245, 0.0681818181818182, 0.25, 0.272727272727273, 0.277777777777778, 0.171428571428571, 0.125, 0.106382978723404, 0.117647058823529, 0.102564102564103, 0.0769230769230769, 0.153846153846154, 0.142857142857143, 0.0769230769230769, 0.0714285714285714), VINM940101_sum = c(22.304, 31.144, 37.096, 35.833, 59.112, 50.142, 45.352, 12.081, 11.146, 18.384, 35.662, 56.304, 47.082, 33.893, 39.612, 39.445, 13.165, 14.194, 26.089, 27.957), VINM940101_avg = c(1.01381818181818, 1.00464516129032, 1.00259459459459, 0.995361111111111, 1.0191724137931, 1.02330612244898, 1.03072727272727, 1.00675, 1.01327272727273, 1.02133333333333, 1.01891428571429, 1.00542857142857, 1.00174468085106, 0.99685294117647, 1.01569230769231, 1.01141025641026, 1.01269230769231, 1.01385714285714, 1.00342307692308, 0.998464285714285), FAUJ880103_sum = c(69.87, 96.24, 117.12, 124.02, 178.98, 147.72, 125.68, 40.87, 36.87, 50.71, 111.67, 179.45, 159.47, 114.76, 128.51, 127.74, 43.82, 45.2, 77.09, 91.07), FAUJ880103_avg = c(3.17590909090909, 3.10451612903226, 3.16540540540541, 3.445, 3.08586206896552, 3.01469387755102, 2.85636363636364, 3.40583333333333, 3.35181818181818, 2.81722222222222, 3.19057142857143, 3.20446428571429, 3.39297872340426, 3.37529411764706, 3.2951282051282, 3.27538461538462, 3.37076923076923, 3.22857142857143, 2.965, 3.2525), GUYH850105_sum = c(3.53, 2.59, 5.02, 3.74, 7.47, 5.33, 6.64, 3.44, 3.88, 4.7, 6.18, 2.33, 0.62, -0.170000000000001, 7.6, 5.99, 1.5, 2.47, 2.15, 2.99), GUYH850105_avg = c(0.160454545454545, 0.0835483870967742, 0.135675675675676, 0.103888888888889, 0.128793103448276, 0.108775510204082, 0.150909090909091, 0.286666666666667, 0.352727272727273, 0.261111111111111, 0.176571428571429, 0.0416071428571428, 0.0131914893617021, -0.00500000000000004, 0.194871794871795, 0.153589743589744, 0.115384615384615, 0.176428571428571, 0.0826923076923077, 0.106785714285714), NOZY710101_sum = c(13.3, 21.5, 25.8, 29.9, 32.8, 26.3, 18.1, 7.9, 6.1, 8.1, 19.9, 40.5, 38, 27.2, 20, 21.8, 8.7, 8.6, 17.5, 21.2), NOZY710101_avg = c(0.604545454545455, 0.693548387096774, 0.697297297297297, 0.830555555555555, 0.56551724137931, 0.536734693877551, 0.411363636363636, 0.658333333333333, 0.554545454545455, 0.45, 0.568571428571429, 0.723214285714286, 0.808510638297872, 0.8, 0.512820512820513, 0.558974358974359, 0.669230769230769, 0.614285714285714, 0.673076923076923, 0.757142857142857)), .Names = c("peptide_sequence", "apex", "length", "A_sum", "R_sum", "N_sum", "D_sum", "C_sum", "Q_sum", "E_sum", "G_sum", "H_sum", "I_sum", "L_sum", "K_sum", "M_sum", "F_sum", "P_sum", "S_sum", "T_sum", "W_sum", "Y_sum", "V_sum", "A_avg", "R_avg", "N_avg", "D_avg", "C_avg", "Q_avg", "E_avg", "G_avg", "H_avg", "I_avg", "L_avg", "K_avg", "M_avg", "F_avg", "P_avg", "S_avg", "T_avg", "W_avg", "Y_avg", "V_avg", "FASG760101_sum", "FASG760101_avg", "CHOP780201_sum", "CHOP780201_avg", "CHOP780202_sum", "CHOP780202_avg", "CHOP780203_sum", "CHOP780203_avg", "WERD780101_sum", "WERD780101_avg", "ZIMJ680104_sum", "ZIMJ680104_avg", "KLEP840101_sum", "KLEP840101_avg", "EISD860102_sum", "EISD860102_avg", "FAUJ880111_sum", "FAUJ880111_avg", "VINM940101_sum", "VINM940101_avg", "FAUJ880103_sum", "FAUJ880103_avg", "GUYH850105_sum", "GUYH850105_avg", "NOZY710101_sum", "NOZY710101_avg"), row.names = c(NA, -20L), class = "apexFeatures"), tolerance = .001))
})

# pcfeatures.apexFeatures
test_that("pcfeatures.apexFeatures", {
	expect_that(pcfeatures.apexFeatures(list("peptide_sequence"="MASTDFSKIETLKQLNASLADK","apex"=factor(0))),equals(structure(list(peptide_sequence = "MASTDFSKIETLKQLNASLADK", apex = structure(1L, .Label = "0", class = "factor"), length = 22L, A_sum = 3, R_sum = 0, N_sum = 1, D_sum = 2, C_sum = 0, Q_sum = 1, E_sum = 1, G_sum = 0, H_sum = 0, I_sum = 1, L_sum = 3, K_sum = 3, M_sum = 1, F_sum = 1, P_sum = 0, S_sum = 3, T_sum = 2, W_sum = 0, Y_sum = 0, V_sum = 0, A_avg = 0.136363636363636, R_avg = 0, N_avg = 0.0454545454545455, D_avg = 0.0909090909090909, C_avg = 0, Q_avg = 0.0454545454545455, E_avg = 0.0454545454545455, G_avg = 0, H_avg = 0, I_avg = 0.0454545454545455, L_avg = 0.136363636363636, K_avg = 0.136363636363636, M_avg = 0.0454545454545455, F_avg = 0.0454545454545455, P_avg = 0, S_avg = 0.136363636363636, T_avg = 0.0909090909090909, W_avg = 0, Y_avg = 0, V_avg = 0, FASG760101_sum = 2790.03, FASG760101_avg = 126.819545454545, CHOP780201_sum = 24.31, CHOP780201_avg = 1.105, CHOP780202_sum = 20.71, CHOP780202_avg = 0.941363636363636, CHOP780203_sum = 21.68, CHOP780203_avg = 0.985454545454545, WERD780101_sum = 11.34, WERD780101_avg = 0.515454545454545, ZIMJ680104_sum = 130.58, ZIMJ680104_avg = 5.93545454545455, KLEP840101_sum = 0, KLEP840101_avg = 0, EISD860102_sum = 39.49, EISD860102_avg = 1.795, FAUJ880111_sum = 3, FAUJ880111_avg = 0.136363636363636, VINM940101_sum = 22.304, VINM940101_avg = 1.01381818181818, FAUJ880103_sum = 69.87, FAUJ880103_avg = 3.17590909090909, GUYH850105_sum = 3.53, GUYH850105_avg = 0.160454545454545, NOZY710101_sum = 13.3, NOZY710101_avg = 0.604545454545455), .Names = c("peptide_sequence", "apex", "length", "A_sum", "R_sum", "N_sum", "D_sum", "C_sum", "Q_sum", "E_sum", "G_sum", "H_sum", "I_sum", "L_sum", "K_sum", "M_sum", "F_sum", "P_sum", "S_sum", "T_sum", "W_sum", "Y_sum", "V_sum", "A_avg", "R_avg", "N_avg", "D_avg", "C_avg", "Q_avg", "E_avg", "G_avg", "H_avg", "I_avg", "L_avg", "K_avg", "M_avg", "F_avg", "P_avg", "S_avg", "T_avg", "W_avg", "Y_avg", "V_avg", "FASG760101_sum", "FASG760101_avg", "CHOP780201_sum", "CHOP780201_avg", "CHOP780202_sum", "CHOP780202_avg", "CHOP780203_sum", "CHOP780203_avg", "WERD780101_sum", "WERD780101_avg", "ZIMJ680104_sum", "ZIMJ680104_avg", "KLEP840101_sum", "KLEP840101_avg", "EISD860102_sum", "EISD860102_avg", "FAUJ880111_sum", "FAUJ880111_avg", "VINM940101_sum", "VINM940101_avg", "FAUJ880103_sum", "FAUJ880103_avg", "GUYH850105_sum", "GUYH850105_avg", "NOZY710101_sum", "NOZY710101_avg"), row.names = c(NA, -1L), class = "data.frame"), tolerance = .001))
})