% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aMNLFA_simultaneous.R
\name{aMNLFA.simultaneous}
\alias{aMNLFA.simultaneous}
\title{aMNLFA simultaneous model fitting function}
\usage{
aMNLFA.simultaneous(input.object)
}
\arguments{
\item{input.object}{The aMNLFA object (created using the aMNLFA.object function) which provides instructions for the function.}
}
\value{
No return value. Generates a file entitled "round3calibration.inp", to be run in \emph{Mplus}, in the directory specified in the aMNLFA.object.
}
\description{
This function generates the simultaneous aMNLFA model from all the initial inputs.
}
\examples{
 wd  <-  tempdir()
 first <- paste0(system.file(package='aMNLFA'),"/extdata")
 the.list  <-  list.files(first,full.names=TRUE)
 file.copy(the.list,wd,overwrite=TRUE)
   
 ob  <-  aMNLFA::aMNLFA.object(dir = wd, 
 mrdata = xstudy, 
 indicators = paste0("bin_", 1:12),
 catindicators = paste0("bin_", 1:12), 
 meanimpact = c("AGE", "GENDER", "STUDY"), 
 varimpact = c("AGE", "GENDER", "STUDY"), 
 measinvar = c("AGE", "GENDER", "STUDY"),
 factors = c("GENDER", "STUDY"),
 ID = "ID",
 thresholds = FALSE)
 
 aMNLFA.simultaneous(ob)
}
\keyword{MNLFA}
