% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_arb_single.R
\name{get_arb_single}
\alias{get_arb_single}
\title{Find arbitrage opportunity information for an www.oddschecker.com event}
\usage{
get_arb_single(event, full = FALSE, print_urls = FALSE, in_play = TRUE)
}
\arguments{
\item{event}{A www.oddschecker.com event URL, given as a string. This will be of the form:
"https://www.oddschecker.com/football/english/championship/bournemouth-v-reading/winner"}

\item{full}{A logical indicating whether or not the best bookie choices should
still be returned for the event, even if there is no arb available.}

\item{print_urls}{Logical. Should the URL of the event(s) be printed to the console while
searching for arbitrage opportunities?}

\item{in_play}{Logical. Should in-play arbitrage opportunities (arbs) also be returned?}
}
\description{
Find (among other information) the implied total probability of all listed
outcomes, Pr(Omega), and if an arb is available, the best bookie combination
to exploit the arb.
}
\details{
This function assumes that the listed outcomes are the only ones that are possible.
Sometimes bookies may not offer odds on a realistic outcome, often if they feel like
it is extremely likely to happen and therefore would offer next to no returns for
any punter. This may mean that an outcome isn't listed and thus the function assumes it
isn't possible. Therefore, the results of this function may be incorrect and assume
a huge arbs is possible, when it isn't. It is therefore required that the user check
the given outcomes given in the results, to ensure they form a complete set. Often, this
is obvious however, as they are simply win, draw or lose.
}
